/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.unsignedlong;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.IndexSortSortedNumericDocValuesRangeQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.SortedNumericLongValues;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockSourceReader;
import org.elasticsearch.index.mapper.CompositeSyntheticFieldLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FallbackSyntheticSourceBlockLoader;
import org.elasticsearch.index.mapper.FieldArrayContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.IgnoreMalformedStoredValues;
import org.elasticsearch.index.mapper.IgnoredSourceFieldMapper;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SortedNumericDocValuesSyntheticFieldLoader;
import org.elasticsearch.index.mapper.SortedNumericWithOffsetsDocValuesSyntheticFieldLoaderLayer;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.blockloader.docvalues.LongsBlockLoader;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.TimeSeriesValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.unsignedlong.SourceValueFetcherSortedUnsignedLongIndexFieldData;
import org.elasticsearch.xpack.unsignedlong.UnsignedLongDocValuesField;
import org.elasticsearch.xpack.unsignedlong.UnsignedLongIndexFieldData;
import org.elasticsearch.xpack.unsignedlong.UnsignedLongLeafFieldData;

public class UnsignedLongFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "unsigned_long";
    private static final long MASK_2_63 = Long.MIN_VALUE;
    static final BigInteger BIGINTEGER_2_64_MINUS_ONE = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);
    private static final BigDecimal BIGDECIMAL_2_64_MINUS_ONE = new BigDecimal(BIGINTEGER_2_64_MINUS_ONE);
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.getIndexSettings()));
    private final boolean isSourceSynthetic;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;
    private final Explicit<Boolean> ignoreMalformed;
    private final String nullValue;
    private final Long nullValueIndexed;
    private final boolean dimension;
    private final TimeSeriesParams.MetricType metricType;
    private final IndexSettings indexSettings;
    private final String offsetsFieldName;

    private static UnsignedLongFieldMapper toType(FieldMapper in) {
        return (UnsignedLongFieldMapper)in;
    }

    private UnsignedLongFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, boolean isSourceSynthetic, Builder builder, String offsetsFieldName) {
        super(simpleName, mappedFieldType, builderParams);
        this.isSourceSynthetic = isSourceSynthetic;
        this.indexed = (Boolean)builder.indexed.getValue();
        this.hasDocValues = (Boolean)builder.hasDocValues.getValue();
        this.stored = (Boolean)builder.stored.getValue();
        this.ignoreMalformed = (Explicit)builder.ignoreMalformed.getValue();
        this.nullValue = (String)builder.nullValue.getValue();
        if (this.nullValue == null) {
            this.nullValueIndexed = null;
        } else {
            long parsed = UnsignedLongFieldMapper.parseUnsignedLong(this.nullValue);
            this.nullValueIndexed = UnsignedLongFieldMapper.unsignedToSortableSignedLong(parsed);
        }
        this.dimension = (Boolean)builder.dimension.getValue();
        this.metricType = (TimeSeriesParams.MetricType)builder.metric.getValue();
        this.indexSettings = builder.indexSettings;
        this.offsetsFieldName = offsetsFieldName;
    }

    public boolean ignoreMalformed() {
        return (Boolean)this.ignoreMalformed.value();
    }

    public UnsignedLongFieldType fieldType() {
        return (UnsignedLongFieldType)super.fieldType();
    }

    public String getOffsetFieldName() {
        return this.offsetsFieldName;
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        Long numericValue;
        XContentParser parser = context.parser();
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            numericValue = null;
        } else if (parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
            numericValue = null;
        } else {
            try {
                numericValue = parser.currentToken() == XContentParser.Token.VALUE_NUMBER ? Long.valueOf(UnsignedLongFieldMapper.parseUnsignedLong(parser.numberValue())) : Long.valueOf(UnsignedLongFieldMapper.parseUnsignedLong(parser.text()));
            }
            catch (IllegalArgumentException e) {
                if (((Boolean)this.ignoreMalformed.value()).booleanValue() && parser.currentToken().isValue()) {
                    context.addIgnoredField(this.mappedFieldType.name());
                    if (this.isSourceSynthetic) {
                        context.doc().add((IndexableField)IgnoreMalformedStoredValues.storedField((String)this.fullPath(), (XContentParser)context.parser()));
                    }
                    return;
                }
                throw e;
            }
        }
        boolean isNullValue = false;
        if (numericValue == null) {
            numericValue = this.nullValueIndexed;
            isNullValue = true;
        } else {
            numericValue = UnsignedLongFieldMapper.unsignedToSortableSignedLong(numericValue);
        }
        if (this.dimension && numericValue != null) {
            context.getRoutingFields().addUnsignedLong(this.fieldType().name(), numericValue.longValue());
        }
        if (numericValue != null) {
            ArrayList<Object> fields = new ArrayList<Object>();
            if (this.indexed && this.hasDocValues) {
                fields.add(new LongField(this.fieldType().name(), numericValue.longValue(), Field.Store.NO));
            } else if (this.hasDocValues) {
                if (this.fieldType().indexType().hasDocValuesSkipper()) {
                    fields.add(SortedNumericDocValuesField.indexedField((String)this.fieldType().name(), (long)numericValue));
                } else {
                    fields.add(new SortedNumericDocValuesField(this.fieldType().name(), numericValue.longValue()));
                }
            } else if (this.indexed) {
                fields.add(new LongPoint(this.fieldType().name(), new long[]{numericValue}));
            }
            if (this.stored) {
                String storedValued = isNullValue ? this.nullValue : Long.toUnsignedString(UnsignedLongFieldMapper.unsignedToSortableSignedLong(numericValue));
                fields.add(new StoredField(this.fieldType().name(), storedValued));
            }
            context.doc().addAll(fields);
            if (!this.hasDocValues && (this.stored || this.indexed)) {
                context.addToFieldNames(this.fieldType().name());
            }
        }
        if (this.offsetsFieldName != null && context.isImmediateParentAnArray() && context.canAddIgnoredField()) {
            if (numericValue != null) {
                context.getOffSetContext().recordOffset(this.offsetsFieldName, (Comparable)numericValue);
            } else {
                context.getOffSetContext().recordNull(this.offsetsFieldName);
            }
        }
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.indexSettings).dimension(this.dimension).metric(this.metricType).init(this);
    }

    private static long parseUnsignedLong(Object value) {
        if (value instanceof Number) {
            if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
                long lv = ((Number)value).longValue();
                if (lv < 0L) {
                    throw new IllegalArgumentException("Value [" + lv + "] is out of range for unsigned long.");
                }
                return lv;
            }
            if (value instanceof Double || value instanceof Float) {
                Number v = (Number)value;
                if (Double.compare(v.doubleValue(), Math.floor(v.doubleValue())) != 0) {
                    throw new IllegalArgumentException("Value \"" + String.valueOf(value) + "\" has a decimal part");
                }
                return UnsignedLongFieldMapper.parseUnsignedLong(v.longValue());
            }
            if (value instanceof BigInteger) {
                BigInteger bigIntegerValue = (BigInteger)value;
                if (bigIntegerValue.compareTo(BIGINTEGER_2_64_MINUS_ONE) > 0 || bigIntegerValue.compareTo(BigInteger.ZERO) < 0) {
                    throw new IllegalArgumentException("Value [" + String.valueOf(bigIntegerValue) + "] is out of range for unsigned long");
                }
                return bigIntegerValue.longValue();
            }
            if (value instanceof BigDecimal) {
                return UnsignedLongFieldMapper.parseUnsignedLong(((BigDecimal)value).toBigIntegerExact());
            }
            throw new IllegalArgumentException("For input string: [" + String.valueOf(value) + "].");
        }
        String stringValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
        try {
            return Long.parseUnsignedLong(stringValue);
        }
        catch (NumberFormatException ignored) {
            BigInteger bigInteger;
            try {
                BigDecimal bigDecimal = new BigDecimal(stringValue);
                bigInteger = bigDecimal.toBigIntegerExact();
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("Value \"" + stringValue + "\" has a decimal part");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("For input string: \"" + stringValue + "\"");
            }
            return UnsignedLongFieldMapper.parseUnsignedLong(bigInteger);
        }
    }

    private static long unsignedToSortableSignedLong(long value) {
        return value ^ Long.MIN_VALUE;
    }

    protected static long sortableSignedLongToUnsigned(long value) {
        return value ^ Long.MIN_VALUE;
    }

    public void doValidate(MappingLookup lookup) {
        if (this.dimension && null != lookup.nestedLookup().getNestedParent(this.fullPath())) {
            throw new IllegalArgumentException("time_series_dimension can't be configured in nested field [" + this.fullPath() + "]");
        }
    }

    private SourceLoader.SyntheticFieldLoader docValuesSyntheticFieldLoader() {
        if (this.offsetsFieldName != null) {
            ArrayList<Object> layers = new ArrayList<Object>(2);
            layers.add(new SortedNumericWithOffsetsDocValuesSyntheticFieldLoaderLayer(this.fullPath(), this.offsetsFieldName, (b, value) -> b.value(DocValueFormat.UNSIGNED_LONG_SHIFTED.format(value))));
            if (((Boolean)this.ignoreMalformed.value()).booleanValue()) {
                layers.add(new CompositeSyntheticFieldLoader.MalformedValuesLayer(this.fullPath()));
            }
            return new CompositeSyntheticFieldLoader(this.leafName(), this.fullPath(), layers);
        }
        return new SortedNumericDocValuesSyntheticFieldLoader(this, this.fullPath(), this.leafName(), this.ignoreMalformed()){

            protected void writeValue(XContentBuilder b, long value) throws IOException {
                b.value(DocValueFormat.UNSIGNED_LONG_SHIFTED.format(value));
            }
        };
    }

    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        if (this.hasDocValues) {
            return new FieldMapper.SyntheticSourceSupport.Native(this::docValuesSyntheticFieldLoader);
        }
        return super.syntheticSourceSupport();
    }

    public static final class Builder
    extends FieldMapper.DimensionBuilder {
        private final FieldMapper.Parameter<Boolean> indexed;
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> UnsignedLongFieldMapper.toType((FieldMapper)m).hasDocValues, (boolean)true);
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> UnsignedLongFieldMapper.toType((FieldMapper)m).stored, (boolean)false);
        private final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        private final FieldMapper.Parameter<String> nullValue;
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<Boolean> dimension;
        private final FieldMapper.Parameter<TimeSeriesParams.MetricType> metric;
        private final IndexSettings indexSettings;

        public Builder(String name, IndexSettings indexSettings) {
            super(name);
            this.ignoreMalformed = FieldMapper.Parameter.explicitBoolParam((String)"ignore_malformed", (boolean)true, m -> UnsignedLongFieldMapper.toType((FieldMapper)m).ignoreMalformed, (boolean)((Boolean)FieldMapper.IGNORE_MALFORMED_SETTING.get(indexSettings.getSettings())));
            this.nullValue = new FieldMapper.Parameter("null_value", false, () -> null, (n, c, o) -> this.parseNullValueAsString(o), m -> UnsignedLongFieldMapper.toType((FieldMapper)m).nullValue, XContentBuilder::field, Objects::toString).acceptsNull();
            this.dimension = TimeSeriesParams.dimensionParam(m -> UnsignedLongFieldMapper.toType((FieldMapper)m).dimension, () -> this.hasDocValues.get());
            this.indexed = FieldMapper.Parameter.indexParam(m -> UnsignedLongFieldMapper.toType((FieldMapper)m).indexed, () -> {
                if (FieldMapper.Parameter.useTimeSeriesDocValuesSkippers((IndexSettings)indexSettings, (boolean)((Boolean)this.dimension.get()))) {
                    return false;
                }
                if (indexSettings.getMode() == IndexMode.TIME_SERIES) {
                    TimeSeriesParams.MetricType metricType = (TimeSeriesParams.MetricType)this.getMetric().getValue();
                    return metricType != TimeSeriesParams.MetricType.COUNTER && metricType != TimeSeriesParams.MetricType.GAUGE;
                }
                return true;
            });
            this.metric = TimeSeriesParams.metricParam(m -> UnsignedLongFieldMapper.toType((FieldMapper)m).metricType, (TimeSeriesParams.MetricType[])new TimeSeriesParams.MetricType[]{TimeSeriesParams.MetricType.GAUGE, TimeSeriesParams.MetricType.COUNTER}).addValidator(v -> {
                if (v != null && !((Boolean)this.hasDocValues.getValue()).booleanValue()) {
                    throw new IllegalArgumentException("Field [time_series_metric] requires that [" + this.hasDocValues.name + "] is true");
                }
            }).precludesParameters(new FieldMapper.Parameter[]{this.dimension});
            this.indexSettings = indexSettings;
        }

        private String parseNullValueAsString(Object o) {
            if (o == null) {
                return null;
            }
            try {
                UnsignedLongFieldMapper.parseUnsignedLong(o);
                return o instanceof BytesRef ? ((BytesRef)o).utf8ToString() : o.toString();
            }
            catch (Exception e) {
                throw new MapperParsingException("Error parsing [null_value] on field [" + this.leafName() + "]: " + e.getMessage(), (Throwable)e);
            }
        }

        Builder nullValue(String nullValue) {
            this.nullValue.setValue((Object)nullValue);
            return this;
        }

        public Builder dimension(boolean dimension) {
            this.dimension.setValue((Object)dimension);
            return this;
        }

        public Builder metric(TimeSeriesParams.MetricType metric) {
            this.metric.setValue((Object)metric);
            return this;
        }

        private FieldMapper.Parameter<TimeSeriesParams.MetricType> getMetric() {
            return this.metric;
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.indexed, this.hasDocValues, this.stored, this.ignoreMalformed, this.nullValue, this.meta, this.dimension, this.metric};
        }

        Number parsedNullValue() {
            if (this.nullValue.getValue() == null) {
                return null;
            }
            long parsed = UnsignedLongFieldMapper.parseUnsignedLong(this.nullValue.getValue());
            return parsed >= 0L ? Long.valueOf(parsed) : BigInteger.valueOf(parsed).and(BIGINTEGER_2_64_MINUS_ONE);
        }

        private IndexType indexType() {
            if (!((Boolean)this.indexed.get()).booleanValue() && ((Boolean)this.hasDocValues.get()).booleanValue()) {
                if (FieldMapper.Parameter.useTimeSeriesDocValuesSkippers((IndexSettings)this.indexSettings, (boolean)((Boolean)this.dimension.get()))) {
                    return IndexType.skippers();
                }
                if (this.indexSettings.useDocValuesSkipper() && this.indexSettings.getIndexVersionCreated().onOrAfter((VersionId)IndexVersions.STANDARD_INDEXES_USE_SKIPPERS)) {
                    return IndexType.skippers();
                }
            }
            return IndexType.points((boolean)((Boolean)this.indexed.get()), (boolean)((Boolean)this.hasDocValues.get()));
        }

        public UnsignedLongFieldMapper build(MapperBuilderContext context) {
            if (this.inheritDimensionParameterFromParentObject(context)) {
                this.dimension.setValue((Object)true);
            }
            UnsignedLongFieldType fieldType = new UnsignedLongFieldType(context.buildFullName(this.leafName()), this.indexType(), (Boolean)this.stored.getValue(), this.parsedNullValue(), (Map)this.meta.getValue(), (Boolean)this.dimension.getValue(), (TimeSeriesParams.MetricType)this.metric.getValue(), this.indexSettings.getMode(), context.isSourceSynthetic());
            String offsetsFieldName = FieldArrayContext.getOffsetsFieldName((MapperBuilderContext)context, (Mapper.SourceKeepMode)this.indexSettings.sourceKeepMode(), (boolean)((Boolean)this.hasDocValues.getValue()), (boolean)((Boolean)this.stored.getValue()), (FieldMapper.Builder)this, (IndexVersion)this.indexSettings.getIndexVersionCreated(), (IndexVersion)IndexVersions.SYNTHETIC_SOURCE_STORE_ARRAYS_NATIVELY_UNSIGNED_LONG);
            return new UnsignedLongFieldMapper(this.leafName(), (MappedFieldType)fieldType, this.builderParams((Mapper.Builder)this, context), context.isSourceSynthetic(), this, offsetsFieldName);
        }
    }

    public static final class UnsignedLongFieldType
    extends SimpleMappedFieldType {
        private final Number nullValueFormatted;
        private final boolean isDimension;
        private final TimeSeriesParams.MetricType metricType;
        private final IndexMode indexMode;
        private final boolean isSyntheticSource;

        public UnsignedLongFieldType(String name, IndexType indexType, boolean isStored, Number nullValueFormatted, Map<String, String> meta, boolean isDimension, TimeSeriesParams.MetricType metricType, IndexMode indexMode, boolean isSyntheticSource) {
            super(name, indexType, isStored, meta);
            this.nullValueFormatted = nullValueFormatted;
            this.isDimension = isDimension;
            this.metricType = metricType;
            this.indexMode = indexMode;
            this.isSyntheticSource = isSyntheticSource;
        }

        public UnsignedLongFieldType(String name) {
            this(name, IndexType.points((boolean)true, (boolean)true), false, null, Collections.emptyMap(), false, null, null, false);
        }

        public String typeName() {
            return UnsignedLongFieldMapper.CONTENT_TYPE;
        }

        public TextSearchInfo getTextSearchInfo() {
            return TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS;
        }

        public boolean mayExistInIndex(SearchExecutionContext context) {
            return context.fieldExistsInIndex(this.name());
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            this.failIfNotIndexed();
            Long longValue = UnsignedLongFieldType.parseTerm(value);
            if (longValue == null) {
                return new MatchNoDocsQuery();
            }
            return LongPoint.newExactQuery((String)this.name(), (long)UnsignedLongFieldMapper.unsignedToSortableSignedLong(longValue));
        }

        public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
            this.failIfNotIndexed();
            long[] lvalues = new long[values.size()];
            int upTo = 0;
            for (Object value : values) {
                Long longValue = UnsignedLongFieldType.parseTerm(value);
                if (longValue == null) continue;
                lvalues[upTo++] = UnsignedLongFieldMapper.unsignedToSortableSignedLong(longValue);
            }
            if (upTo == 0) {
                return new MatchNoDocsQuery();
            }
            if (upTo != lvalues.length) {
                lvalues = Arrays.copyOf(lvalues, upTo);
            }
            return LongPoint.newSetQuery((String)this.name(), (long[])lvalues);
        }

        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            this.failIfNotIndexed();
            long l = Long.MIN_VALUE;
            long u = Long.MAX_VALUE;
            if (lowerTerm != null) {
                Long lt = UnsignedLongFieldType.parseLowerRangeTerm(lowerTerm, includeLower);
                if (lt == null) {
                    return new MatchNoDocsQuery();
                }
                l = UnsignedLongFieldMapper.unsignedToSortableSignedLong(lt);
            }
            if (upperTerm != null) {
                Long ut = UnsignedLongFieldType.parseUpperRangeTerm(upperTerm, includeUpper);
                if (ut == null) {
                    return new MatchNoDocsQuery();
                }
                u = UnsignedLongFieldMapper.unsignedToSortableSignedLong(ut);
            }
            if (l > u) {
                return new MatchNoDocsQuery();
            }
            Query query = LongPoint.newRangeQuery((String)this.name(), (long)l, (long)u);
            if (this.hasDocValues()) {
                Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery((String)this.name(), (long)l, (long)u);
                query = new IndexOrDocValuesQuery(query, dvQuery);
                if (context.indexSortedOnField(this.name())) {
                    query = new IndexSortSortedNumericDocValuesRangeQuery(this.name(), l, u, query);
                }
            }
            return query;
        }

        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (this.indexMode == IndexMode.TIME_SERIES && this.metricType == TimeSeriesParams.MetricType.COUNTER) {
                return BlockLoader.CONSTANT_NULLS;
            }
            if (this.hasDocValues() && (blContext.fieldExtractPreference() != MappedFieldType.FieldExtractPreference.STORED || this.isSyntheticSource)) {
                return new LongsBlockLoader(this.name());
            }
            if (this.isSyntheticSource && blContext.parentField(this.name()) == null) {
                return new FallbackSyntheticSourceBlockLoader(this, this.fallbackSyntheticSourceBlockLoaderReader(), this.name(), IgnoredSourceFieldMapper.ignoredSourceFormat((IndexVersion)blContext.indexSettings().getIndexVersionCreated())){

                    public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
                        return factory.longs(expectedCount);
                    }
                };
            }
            IgnoredSourceFieldMapper.IgnoredSourceFormat ignoredSourceFormat = blContext.indexSettings().getIgnoredSourceFormat();
            SourceValueFetcher valueFetcher = new SourceValueFetcher(blContext.sourcePaths(this.name()), this.nullValueFormatted, ignoredSourceFormat){

                protected Object parseSourceValue(Object value) {
                    if (value.equals("")) {
                        return UnsignedLongFieldMapper.unsignedToSortableSignedLong(UnsignedLongFieldMapper.parseUnsignedLong(nullValueFormatted));
                    }
                    return UnsignedLongFieldMapper.unsignedToSortableSignedLong(UnsignedLongFieldMapper.parseUnsignedLong(value));
                }
            };
            BlockSourceReader.LeafIteratorLookup lookup = !this.hasDocValues() && this.isStored() ? BlockSourceReader.lookupFromFieldNames((FieldNamesFieldMapper.FieldNamesFieldType)blContext.fieldNames(), (String)this.name()) : BlockSourceReader.lookupMatchingAll();
            return new BlockSourceReader.LongsBlockLoader((ValueFetcher)valueFetcher, lookup);
        }

        private FallbackSyntheticSourceBlockLoader.Reader<?> fallbackSyntheticSourceBlockLoaderReader() {
            final Long nullValueEncoded = this.nullValueFormatted != null ? Long.valueOf(UnsignedLongFieldMapper.unsignedToSortableSignedLong(UnsignedLongFieldMapper.parseUnsignedLong(this.nullValueFormatted))) : null;
            return new FallbackSyntheticSourceBlockLoader.SingleValueReader<Number>(this, (Object)this.nullValueFormatted){

                public void convertValue(Object value, List<Number> accumulator) {
                    if (value.equals("") && nullValueEncoded != null) {
                        accumulator.add(nullValueEncoded);
                    }
                    try {
                        long converted = UnsignedLongFieldMapper.unsignedToSortableSignedLong(UnsignedLongFieldMapper.parseUnsignedLong(value));
                        accumulator.add(converted);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                protected void parseNonNullValue(XContentParser parser, List<Number> accumulator) throws IOException {
                    if (parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0 && nullValueEncoded != null) {
                        accumulator.add(nullValueEncoded);
                    }
                    try {
                        Long rawValue = parser.currentToken() == XContentParser.Token.VALUE_NUMBER ? Long.valueOf(UnsignedLongFieldMapper.parseUnsignedLong(parser.numberValue())) : Long.valueOf(UnsignedLongFieldMapper.parseUnsignedLong(parser.text()));
                        long converted = UnsignedLongFieldMapper.unsignedToSortableSignedLong(rawValue);
                        accumulator.add(converted);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                public void writeToBlock(List<Number> values, BlockLoader.Builder blockBuilder) {
                    BlockLoader.LongBuilder longBuilder = (BlockLoader.LongBuilder)blockBuilder;
                    for (Number value : values) {
                        longBuilder.appendLong(value.longValue());
                    }
                }
            };
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            ValuesSourceType valuesSourceType;
            MappedFieldType.FielddataOperation operation = fieldDataContext.fielddataOperation();
            if (operation == MappedFieldType.FielddataOperation.SEARCH) {
                this.failIfNoDocValues();
            }
            Object object = valuesSourceType = this.indexMode == IndexMode.TIME_SERIES && this.metricType == TimeSeriesParams.MetricType.COUNTER ? TimeSeriesValuesSourceType.COUNTER : IndexNumericFieldData.NumericType.LONG.getValuesSourceType();
            if ((operation == MappedFieldType.FielddataOperation.SEARCH || operation == MappedFieldType.FielddataOperation.SCRIPT) && this.hasDocValues()) {
                return (cache, breakerService) -> {
                    SortedNumericIndexFieldData signedLongValues = new SortedNumericIndexFieldData.Builder(this.name(), IndexNumericFieldData.NumericType.LONG, valuesSourceType, (dv, n) -> {
                        throw new UnsupportedOperationException();
                    }, this.indexType).build(cache, breakerService);
                    return new UnsignedLongIndexFieldData((IndexNumericFieldData)signedLongValues, (ToScriptFieldFactory<SortedNumericLongValues>)((ToScriptFieldFactory)UnsignedLongDocValuesField::new), this.indexType);
                };
            }
            if (operation == MappedFieldType.FielddataOperation.SCRIPT) {
                SearchLookup searchLookup = (SearchLookup)fieldDataContext.lookupSupplier().get();
                Set sourcePaths = (Set)fieldDataContext.sourcePathsLookup().apply(this.name());
                return new SourceValueFetcherSortedUnsignedLongIndexFieldData.Builder(this.name(), valuesSourceType, (ValueFetcher)this.sourceValueFetcher(sourcePaths, fieldDataContext.indexSettings()), (SourceProvider)searchLookup, (ToScriptFieldFactory<SortedNumericLongValues>)((ToScriptFieldFactory)UnsignedLongDocValuesField::new));
            }
            throw new IllegalStateException("unknown field data operation [" + operation.name() + "]");
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return this.sourceValueFetcher(context.isSourceEnabled() ? context.sourcePath(this.name()) : Collections.emptySet(), context.getIndexSettings());
        }

        private SourceValueFetcher sourceValueFetcher(Set<String> sourcePaths, IndexSettings indexSettings) {
            return new SourceValueFetcher(sourcePaths, this.nullValueFormatted, indexSettings.getIgnoredSourceFormat()){

                protected Object parseSourceValue(Object value) {
                    if (value.equals("")) {
                        return nullValueFormatted;
                    }
                    long ulValue = UnsignedLongFieldMapper.parseUnsignedLong(value);
                    if (ulValue >= 0L) {
                        return ulValue;
                    }
                    return BigInteger.valueOf(ulValue).and(BIGINTEGER_2_64_MINUS_ONE);
                }
            };
        }

        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return value;
        }

        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            this.checkNoTimeZone(timeZone);
            return DocValueFormat.UNSIGNED_LONG_SHIFTED;
        }

        public Function<byte[], Number> pointReaderIfPossible() {
            if (this.indexType.hasPoints()) {
                return value -> UnsignedLongLeafFieldData.convertUnsignedLongToDouble(LongPoint.decodeDimension((byte[])value, (int)0));
            }
            return null;
        }

        public MappedFieldType.CollapseType collapseType() {
            return MappedFieldType.CollapseType.NUMERIC;
        }

        static Long parseTerm(Object value) {
            if (value instanceof Number) {
                BigInteger bigIntegerValue;
                if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
                    long lv = ((Number)value).longValue();
                    if (lv >= 0L) {
                        return lv;
                    }
                } else if (value instanceof BigInteger && (bigIntegerValue = (BigInteger)value).compareTo(BigInteger.ZERO) >= 0 && bigIntegerValue.compareTo(BIGINTEGER_2_64_MINUS_ONE) <= 0) {
                    return bigIntegerValue.longValue();
                }
            } else {
                String stringValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
                try {
                    return Long.parseUnsignedLong(stringValue);
                }
                catch (NumberFormatException e) {
                    Double.parseDouble(stringValue);
                }
            }
            return null;
        }

        static Long parseLowerRangeTerm(Object value, boolean include) {
            boolean hasDecimal;
            if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
                long longValue = ((Number)value).longValue();
                if (longValue < 0L) {
                    return 0L;
                }
                if (!include) {
                    longValue = longValue == Long.MAX_VALUE ? Long.MIN_VALUE : (longValue = longValue + 1L);
                }
                return longValue;
            }
            String stringValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            BigDecimal bigDecimalValue = new BigDecimal(stringValue);
            if (bigDecimalValue.compareTo(BigDecimal.ZERO) < 0) {
                return 0L;
            }
            int c = bigDecimalValue.compareTo(BIGDECIMAL_2_64_MINUS_ONE);
            if (c > 0 || c == 0 && !include) {
                return null;
            }
            long longValue = bigDecimalValue.longValue();
            boolean bl = hasDecimal = bigDecimalValue.scale() > 0 && bigDecimalValue.stripTrailingZeros().scale() > 0;
            if (!include || hasDecimal) {
                ++longValue;
            }
            return longValue;
        }

        static Long parseUpperRangeTerm(Object value, boolean include) {
            boolean hasDecimal;
            if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
                long longValue = ((Number)value).longValue();
                if (longValue < 0L || longValue == 0L && !include) {
                    return null;
                }
                longValue = include ? longValue : (longValue = longValue - 1L);
                return longValue;
            }
            String stringValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            BigDecimal bigDecimalValue = new BigDecimal(stringValue);
            int c = bigDecimalValue.compareTo(BigDecimal.ZERO);
            if (c < 0 || c == 0 && !include) {
                return null;
            }
            if (bigDecimalValue.compareTo(BIGDECIMAL_2_64_MINUS_ONE) > 0) {
                return -1L;
            }
            long longValue = bigDecimalValue.longValue();
            boolean bl = hasDecimal = bigDecimalValue.scale() > 0 && bigDecimalValue.stripTrailingZeros().scale() > 0;
            if (!include && !hasDecimal) {
                --longValue;
            }
            return longValue;
        }

        public boolean isDimension() {
            return this.isDimension;
        }

        public TimeSeriesParams.MetricType getMetricType() {
            return this.metricType;
        }
    }
}

