/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reindex;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.metric.LongHistogram;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public class ReindexMetrics {
    public static final String REINDEX_TIME_HISTOGRAM = "es.reindex.duration.histogram";
    public static final String REINDEX_COMPLETION_COUNTER = "es.reindex.completion.total";
    public static final String ATTRIBUTE_NAME_ERROR_TYPE = "error.type";
    public static final String ATTRIBUTE_NAME_SOURCE = "reindex.source";
    public static final String ATTRIBUTE_VALUE_SOURCE_LOCAL = "local";
    public static final String ATTRIBUTE_VALUE_SOURCE_REMOTE = "remote";
    private final LongHistogram reindexTimeSecsHistogram;
    private final LongCounter reindexCompletionCounter;

    public ReindexMetrics(MeterRegistry meterRegistry) {
        this.reindexTimeSecsHistogram = meterRegistry.registerLongHistogram(REINDEX_TIME_HISTOGRAM, "Time to reindex by search", "seconds");
        this.reindexCompletionCounter = meterRegistry.registerLongCounter(REINDEX_COMPLETION_COUNTER, "Number of completed reindex operations", "unit");
    }

    public long recordTookTime(long tookTime, boolean remote) {
        Map<String, Object> attributes = this.getAttributes(remote);
        this.reindexTimeSecsHistogram.record(tookTime, attributes);
        return tookTime;
    }

    public void recordSuccess(boolean remote) {
        Map<String, Object> attributes = this.getAttributes(remote);
        assert (attributes.get(ATTRIBUTE_NAME_ERROR_TYPE) == null) : "error.type attribute must not be present for successes";
        this.reindexCompletionCounter.incrementBy(1L, attributes);
    }

    public void recordFailure(boolean remote, Throwable e) {
        String errorType;
        Map<String, Object> attributes = this.getAttributes(remote);
        if (e instanceof ElasticsearchStatusException) {
            ElasticsearchStatusException ese = (ElasticsearchStatusException)e;
            errorType = ese.status().name();
        } else {
            errorType = e.getClass().getTypeName();
        }
        attributes.put(ATTRIBUTE_NAME_ERROR_TYPE, errorType);
        assert (attributes.get(ATTRIBUTE_NAME_ERROR_TYPE) != null) : "error.type attribute must be present for failures";
        this.reindexCompletionCounter.incrementBy(1L, attributes);
    }

    private Map<String, Object> getAttributes(boolean remote) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(ATTRIBUTE_NAME_SOURCE, remote ? ATTRIBUTE_VALUE_SOURCE_REMOTE : ATTRIBUTE_VALUE_SOURCE_LOCAL);
        return attributes;
    }
}

