/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb.patterntext;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.CompositeSyntheticFieldLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.StringStoredFieldFieldLoader;
import org.elasticsearch.index.mapper.TextParams;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.logsdb.patterntext.Arg;
import org.elasticsearch.xpack.logsdb.patterntext.DelimiterAnalyzer;
import org.elasticsearch.xpack.logsdb.patterntext.PatternTextCompositeValues;
import org.elasticsearch.xpack.logsdb.patterntext.PatternTextFieldType;
import org.elasticsearch.xpack.logsdb.patterntext.PatternTextSyntheticFieldLoaderLayer;
import org.elasticsearch.xpack.logsdb.patterntext.PatternTextValueProcessor;

public class PatternTextFieldMapper
extends FieldMapper {
    private static final NamedAnalyzer STANDARD_ANALYZER = new NamedAnalyzer("standard", AnalyzerScope.GLOBAL, (Analyzer)new StandardAnalyzer());
    public static final Setting<Boolean> DISABLE_TEMPLATING_SETTING = Setting.boolSetting((String)"index.mapping.pattern_text.disable_templating", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.PrivateIndex});
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser(Builder::new);
    private final IndexVersion indexCreatedVersion;
    private final NamedAnalyzer analyzer;
    private final IndexSettings indexSettings;
    private final String indexOptions;
    private final FieldType fieldType;
    private final KeywordFieldMapper templateIdMapper;

    private PatternTextFieldMapper(String simpleName, FieldType fieldType, PatternTextFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, Builder builder, KeywordFieldMapper templateIdMapper) {
        super(simpleName, (MappedFieldType)mappedFieldType, builderParams);
        assert (mappedFieldType.getTextSearchInfo().isTokenized());
        assert (!mappedFieldType.hasDocValues());
        this.fieldType = fieldType;
        this.indexCreatedVersion = builder.indexCreatedVersion();
        this.analyzer = (NamedAnalyzer)builder.analyzer.get();
        this.indexSettings = builder.indexSettings;
        this.indexOptions = (String)builder.indexOptions.getValue();
        this.templateIdMapper = templateIdMapper;
    }

    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of(this.mappedFieldType.name(), this.analyzer);
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.indexCreatedVersion, this.indexSettings, this.fieldType().isWithinMultiField()).init(this);
    }

    public Iterator<Mapper> iterator() {
        ArrayList<Object> mappers = new ArrayList<Object>();
        Iterator m = super.iterator();
        while (m.hasNext()) {
            mappers.add((Mapper)m.next());
        }
        mappers.add(this.templateIdMapper);
        return mappers.iterator();
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        String value = context.parser().textOrNull();
        if (value == null) {
            return;
        }
        IndexableField existingValue = context.doc().getField(this.fieldType().name());
        if (existingValue != null) {
            throw new IllegalArgumentException("Multiple values are not allowed for field [" + this.fieldType().name() + "].");
        }
        context.doc().add((IndexableField)new Field(this.fieldType().name(), (CharSequence)value, (IndexableFieldType)this.fieldType));
        if (this.fieldType().disableTemplating()) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().storedNamed(), new BytesRef((CharSequence)value)));
            return;
        }
        PatternTextValueProcessor.Parts parts = PatternTextValueProcessor.split(value);
        context.doc().add((IndexableField)this.templateIdMapper.buildKeywordField(new BytesRef((CharSequence)parts.templateId())));
        if (parts.useStoredField()) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().storedNamed(), new BytesRef((CharSequence)value)));
        } else {
            context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().templateFieldName(), new BytesRef((CharSequence)parts.template())));
            String argsInfoEncoded = Arg.encodeInfo(parts.argsInfo());
            context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().argsInfoFieldName(), new BytesRef((CharSequence)argsInfoEncoded)));
            if (!parts.args().isEmpty()) {
                String remainingArgs = Arg.encodeRemainingArgs(parts);
                context.doc().add((IndexableField)new SortedSetDocValuesField(this.fieldType().argsFieldName(), new BytesRef((CharSequence)remainingArgs)));
            }
        }
    }

    protected String contentType() {
        return "pattern_text";
    }

    public PatternTextFieldType fieldType() {
        return (PatternTextFieldType)super.fieldType();
    }

    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        return new FieldMapper.SyntheticSourceSupport.Native(this::getSyntheticFieldLoader);
    }

    private SourceLoader.SyntheticFieldLoader getSyntheticFieldLoader() {
        if (this.fieldType().disableTemplating()) {
            return new StringStoredFieldFieldLoader(this, this.fieldType().storedNamed(), this.fieldType().name(), this.leafName()){

                protected void write(XContentBuilder b, Object value) throws IOException {
                    b.value(((BytesRef)value).utf8ToString());
                }
            };
        }
        return new CompositeSyntheticFieldLoader(this.leafName(), this.fullPath(), new CompositeSyntheticFieldLoader.Layer[]{new PatternTextSyntheticFieldLoaderLayer(this.fieldType().name(), leafReader -> PatternTextCompositeValues.from(leafReader, this.fieldType()))});
    }

    NamedAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    public static class Builder
    extends FieldMapper.TextFamilyBuilder {
        private final IndexSettings indexSettings;
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<String> indexOptions = Builder.patternTextIndexOptions(m -> ((PatternTextFieldMapper)m).indexOptions);
        private final FieldMapper.Parameter<NamedAnalyzer> analyzer;
        private final FieldMapper.Parameter<Boolean> disableTemplating;

        public Builder(String name, MappingParserContext context) {
            this(name, context.indexVersionCreated(), context.getIndexSettings(), context.isWithinMultiField());
        }

        public Builder(String name, IndexVersion indexCreatedVersion, IndexSettings indexSettings, boolean isWithinMultiField) {
            super(name, indexCreatedVersion, isWithinMultiField);
            this.indexSettings = indexSettings;
            this.analyzer = Builder.analyzerParam(name, m -> ((PatternTextFieldMapper)m).analyzer);
            this.disableTemplating = Builder.disableTemplatingParameter(indexSettings);
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.meta, this.indexOptions, this.analyzer, this.disableTemplating};
        }

        private PatternTextFieldType buildFieldType(FieldType fieldType, MapperBuilderContext context) {
            NamedAnalyzer analyzer = (NamedAnalyzer)this.analyzer.get();
            TextSearchInfo tsi = new TextSearchInfo(fieldType, null, analyzer, analyzer);
            return new PatternTextFieldType(context.buildFullName(this.leafName()), tsi, (Analyzer)analyzer, (Boolean)this.disableTemplating.getValue(), (Map)this.meta.getValue(), context.isSourceSynthetic(), this.isWithinMultiField());
        }

        private static FieldType buildLuceneFieldType(Supplier<String> indexOptionSupplier) {
            IndexOptions indexOptions = TextParams.toIndexOptions((boolean)true, (String)indexOptionSupplier.get());
            return indexOptions == IndexOptions.DOCS_AND_FREQS_AND_POSITIONS ? Defaults.FIELD_TYPE_POSITIONS : Defaults.FIELD_TYPE_DOCS;
        }

        private static FieldMapper.Parameter<String> patternTextIndexOptions(Function<FieldMapper, String> initializer) {
            return FieldMapper.Parameter.stringParam((String)"index_options", (boolean)false, initializer, (String)"docs").addValidator(v -> {
                switch (v) {
                    case "positions": 
                    case "docs": {
                        return;
                    }
                }
                throw new MapperParsingException("Unknown value [" + v + "] for field [index_options] - accepted values are [positions, docs]");
            });
        }

        private static FieldMapper.Parameter<NamedAnalyzer> analyzerParam(String name, Function<FieldMapper, NamedAnalyzer> initializer) {
            return new FieldMapper.Parameter("analyzer", false, () -> DelimiterAnalyzer.INSTANCE, (n, c, o) -> {
                String analyzerName;
                switch (analyzerName = o.toString()) {
                    case "standard": {
                        return STANDARD_ANALYZER;
                    }
                    case "delimiter": {
                        return DelimiterAnalyzer.INSTANCE;
                    }
                }
                throw new IllegalArgumentException("unsupported analyzer [" + analyzerName + "] for field [" + name + "], supported analyzers are [standard, log]");
            }, initializer, (b, n, v) -> b.field(n, v.name()), NamedAnalyzer::name);
        }

        private static FieldMapper.Parameter<Boolean> disableTemplatingParameter(IndexSettings indexSettings) {
            boolean forceDisable = (Boolean)DISABLE_TEMPLATING_SETTING.get(indexSettings.getSettings());
            return FieldMapper.Parameter.boolParam((String)"disable_templating", (boolean)false, m -> ((PatternTextFieldMapper)((Object)m)).fieldType().disableTemplating(), (boolean)forceDisable).addValidator(value -> {
                if (!value.booleanValue() && forceDisable) {
                    throw new MapperParsingException("value [false] for mapping parameter [disable_templating] contradicts value [true] for index setting [" + DISABLE_TEMPLATING_SETTING.getKey() + "]");
                }
            }).setSerializerCheck((includeDefaults, isConfigured, value) -> includeDefaults || isConfigured || value != false);
        }

        public PatternTextFieldMapper build(MapperBuilderContext context) {
            FieldType fieldType = Builder.buildLuceneFieldType(this.indexOptions);
            PatternTextFieldType patternTextFieldType = this.buildFieldType(fieldType, context);
            FieldMapper.BuilderParams builderParams = this.builderParams((Mapper.Builder)this, context);
            KeywordFieldMapper templateIdMapper = KeywordFieldMapper.Builder.buildWithDocValuesSkipper((String)patternTextFieldType.templateIdFieldName(this.leafName()), (IndexSettings)this.indexSettings, (boolean)this.isWithinMultiField()).indexed(false).build(context);
            return new PatternTextFieldMapper(this.leafName(), fieldType, patternTextFieldType, builderParams, this, templateIdMapper);
        }
    }

    @FunctionalInterface
    static interface DocValuesSupplier {
        public BinaryDocValues get(LeafReader var1) throws IOException;
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE_DOCS;
        public static final FieldType FIELD_TYPE_POSITIONS;

        static {
            FieldType ft = new FieldType();
            ft.setTokenized(true);
            ft.setStored(false);
            ft.setStoreTermVectors(false);
            ft.setOmitNorms(true);
            ft.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE_DOCS = Mapper.freezeAndDeduplicateFieldType((FieldType)ft);
            ft = new FieldType();
            ft.setTokenized(true);
            ft.setStored(false);
            ft.setStoreTermVectors(false);
            ft.setOmitNorms(true);
            ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            FIELD_TYPE_POSITIONS = Mapper.freezeAndDeduplicateFieldType((FieldType)ft);
        }
    }
}

