/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractNonThreadSafeRefCounted;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.TDigestBlock;
import org.elasticsearch.compute.data.TDigestHolder;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

public final class TDigestArrayBlock
extends AbstractNonThreadSafeRefCounted
implements TDigestBlock {
    private final DoubleBlock minima;
    private final DoubleBlock maxima;
    private final DoubleBlock sums;
    private final LongBlock valueCounts;
    private final BytesRefBlock encodedDigests;

    public TDigestArrayBlock(BytesRefBlock encodedDigests, DoubleBlock minima, DoubleBlock maxima, DoubleBlock sums, LongBlock valueCounts) {
        this.encodedDigests = encodedDigests;
        this.minima = minima;
        this.maxima = maxima;
        this.sums = sums;
        this.valueCounts = valueCounts;
        this.assertInvariants();
    }

    private void assertInvariants() {
        for (Block b : this.getSubBlocks()) {
            assert (!b.isReleased());
            assert (!b.doesHaveMultivaluedFields()) : "TDigestArrayBlock sub-blocks can't have multi-values but [" + String.valueOf(b) + "] does";
            assert (b.getPositionCount() == this.getPositionCount()) : "TDigestArrayBlock sub-blocks must have the same position count but [" + String.valueOf(b) + "] has " + b.getPositionCount() + " instead of " + this.getPositionCount();
            for (int i = 0; i < b.getPositionCount(); ++i) {
                if (this.isNull(i)) {
                    assert (b.isNull(i)) : "TDigestArrayBlock sub-block [" + String.valueOf(b) + "] should be null at position " + i + ", but was not";
                    continue;
                }
                if (b == this.sums || b == this.minima || b == this.maxima) {
                    assert (b.isNull(i) == (this.valueCounts.getLong(this.valueCounts.getFirstValueIndex(i)) == 0L)) : "TDigestArrayBlock sums/minima/maxima sub-block [" + String.valueOf(b) + "] has wrong nullity at position " + i;
                    continue;
                }
                assert (!b.isNull(i)) : "TDigestArrayBlock sub-block [" + String.valueOf(b) + "] should be non-null at position " + i + ", but was not";
            }
        }
    }

    private List<Block> getSubBlocks() {
        return List.of(this.minima, this.maxima, this.sums, this.valueCounts, this.encodedDigests);
    }

    @Override
    protected void closeInternal() {
        Releasables.close(this.getSubBlocks());
    }

    @Override
    public Vector asVector() {
        return null;
    }

    @Override
    public int getTotalValueCount() {
        return this.encodedDigests.getTotalValueCount();
    }

    @Override
    public int getPositionCount() {
        return this.encodedDigests.getPositionCount();
    }

    @Override
    public int getFirstValueIndex(int position) {
        return position;
    }

    @Override
    public int getValueCount(int position) {
        return this.isNull(position) ? 0 : 1;
    }

    @Override
    public ElementType elementType() {
        return ElementType.TDIGEST;
    }

    @Override
    public BlockFactory blockFactory() {
        return this.encodedDigests.blockFactory();
    }

    @Override
    public void allowPassingToDifferentDriver() {
        this.getSubBlocks().forEach(Block::allowPassingToDifferentDriver);
    }

    @Override
    public boolean isNull(int position) {
        return this.encodedDigests.isNull(position);
    }

    @Override
    public boolean mayHaveNulls() {
        return this.encodedDigests.mayHaveNulls();
    }

    @Override
    public boolean areAllValuesNull() {
        return this.encodedDigests.areAllValuesNull();
    }

    @Override
    public boolean mayHaveMultivaluedFields() {
        return false;
    }

    @Override
    public boolean doesHaveMultivaluedFields() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Block filter(int ... positions) {
        DoubleBlock filteredMinima = null;
        DoubleBlock filteredMaxima = null;
        DoubleBlock filteredSums = null;
        LongBlock filteredValueCounts = null;
        BytesRefBlock filteredEncodedDigests = null;
        boolean success = false;
        try {
            filteredEncodedDigests = this.encodedDigests.filter(positions);
            filteredMinima = this.minima.filter(positions);
            filteredMaxima = this.maxima.filter(positions);
            filteredSums = this.sums.filter(positions);
            filteredValueCounts = this.valueCounts.filter(positions);
            return new TDigestArrayBlock(filteredEncodedDigests, filteredMinima, filteredMaxima, filteredSums, filteredValueCounts);
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            Releasables.close((Releasable[])new Releasable[]{filteredMinima, filteredMaxima, filteredSums, filteredValueCounts, filteredEncodedDigests});
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Block keepMask(BooleanVector mask) {
        DoubleBlock filteredMinima = null;
        DoubleBlock filteredMaxima = null;
        DoubleBlock filteredSums = null;
        LongBlock filteredValueCounts = null;
        BytesRefBlock filteredEncodedDigests = null;
        boolean success = false;
        try {
            filteredEncodedDigests = this.encodedDigests.keepMask(mask);
            filteredMinima = this.minima.keepMask(mask);
            filteredMaxima = this.maxima.keepMask(mask);
            filteredSums = this.sums.keepMask(mask);
            filteredValueCounts = this.valueCounts.keepMask(mask);
            return new TDigestArrayBlock(filteredEncodedDigests, filteredMinima, filteredMaxima, filteredSums, filteredValueCounts);
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            Releasables.close((Releasable[])new Releasable[]{filteredMinima, filteredMaxima, filteredSums, filteredValueCounts, filteredEncodedDigests});
            throw throwable;
        }
    }

    @Override
    public ReleasableIterator<? extends Block> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        throw new UnsupportedOperationException("Lookup is not supported on TDigestArrayBlock");
    }

    @Override
    public Block.MvOrdering mvOrdering() {
        return Block.MvOrdering.UNORDERED;
    }

    @Override
    public Block expand() {
        this.incRef();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Block deepCopy(BlockFactory blockFactory) {
        DoubleBlock copiedMinima = null;
        DoubleBlock copiedMaxima = null;
        DoubleBlock copiedSums = null;
        LongBlock copiedValueCounts = null;
        BytesRefBlock copiedEncodedDigests = null;
        boolean success = false;
        try {
            copiedEncodedDigests = this.encodedDigests.deepCopy(blockFactory);
            copiedMinima = this.minima.deepCopy(blockFactory);
            copiedMaxima = this.maxima.deepCopy(blockFactory);
            copiedSums = this.sums.deepCopy(blockFactory);
            copiedValueCounts = this.valueCounts.deepCopy(blockFactory);
            return new TDigestArrayBlock(copiedEncodedDigests, copiedMinima, copiedMaxima, copiedSums, copiedValueCounts);
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            Releasables.close((Releasable[])new Releasable[]{copiedMinima, copiedMaxima, copiedSums, copiedValueCounts, copiedEncodedDigests});
            throw throwable;
        }
    }

    void copyInto(BytesRefBlock.Builder encodedDigestsBuilder, DoubleBlock.Builder minimaBuilder, DoubleBlock.Builder maximaBuilder, DoubleBlock.Builder sumsBuilder, LongBlock.Builder valueCountsBuilder, int beginInclusive, int endExclusive) {
        encodedDigestsBuilder.copyFrom(this.encodedDigests, beginInclusive, endExclusive);
        minimaBuilder.copyFrom(this.minima, beginInclusive, endExclusive);
        maximaBuilder.copyFrom(this.maxima, beginInclusive, endExclusive);
        sumsBuilder.copyFrom(this.sums, beginInclusive, endExclusive);
        valueCountsBuilder.copyFrom(this.valueCounts, beginInclusive, endExclusive);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Block.writeTypedBlock(this.encodedDigests, out);
        Block.writeTypedBlock(this.minima, out);
        Block.writeTypedBlock(this.maxima, out);
        Block.writeTypedBlock(this.sums, out);
        Block.writeTypedBlock(this.valueCounts, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TDigestArrayBlock readFrom(BlockStreamInput in) throws IOException {
        BytesRefBlock encodedDigests = null;
        DoubleBlock minima = null;
        DoubleBlock maxima = null;
        DoubleBlock sums = null;
        LongBlock valueCounts = null;
        boolean success = false;
        try {
            encodedDigests = (BytesRefBlock)Block.readTypedBlock(in);
            minima = (DoubleBlock)Block.readTypedBlock(in);
            maxima = (DoubleBlock)Block.readTypedBlock(in);
            sums = (DoubleBlock)Block.readTypedBlock(in);
            valueCounts = (LongBlock)Block.readTypedBlock(in);
            return new TDigestArrayBlock(encodedDigests, minima, maxima, sums, valueCounts);
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            Releasables.close((Releasable[])new Releasable[]{minima, maxima, sums, valueCounts, encodedDigests});
            throw throwable;
        }
    }

    public long ramBytesUsed() {
        long bytes = 0L;
        for (Block b : this.getSubBlocks()) {
            bytes += b.ramBytesUsed();
        }
        return bytes;
    }

    @Override
    public void serializeTDigest(int valueIndex, TDigestBlock.SerializedTDigestOutput out, BytesRef scratch) {
        long valueCount = this.valueCounts.getLong(this.valueCounts.getFirstValueIndex(valueIndex));
        out.appendLong(valueCount);
        if (valueCount > 0L) {
            out.appendDouble(this.sums.getDouble(this.sums.getFirstValueIndex(valueIndex)));
            out.appendDouble(this.minima.getDouble(this.minima.getFirstValueIndex(valueIndex)));
            out.appendDouble(this.maxima.getDouble(this.maxima.getFirstValueIndex(valueIndex)));
        }
        out.appendBytesRef(this.encodedDigests.getBytesRef(this.encodedDigests.getFirstValueIndex(valueIndex), scratch));
    }

    @Override
    public TDigestHolder getTDigestHolder(int offset) {
        return new TDigestHolder(this.encodedDigests.getBytesRef(offset, new BytesRef()), this.minima.getDouble(offset), this.maxima.getDouble(offset), this.sums.getDouble(offset), this.valueCounts.getLong(offset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TDigestBlock createConstant(TDigestHolder histogram, int positionCount, BlockFactory blockFactory) {
        TDigestArrayBlock tDigestArrayBlock;
        block3: {
            DoubleBlock minBlock = null;
            DoubleBlock maxBlock = null;
            DoubleBlock sumBlock = null;
            LongBlock countBlock = null;
            BytesRefBlock encodedDigestsBlock = null;
            boolean success = false;
            try {
                countBlock = blockFactory.newConstantLongBlockWith(histogram.getValueCount(), positionCount);
                minBlock = Double.isNaN(histogram.getMin()) ? (DoubleBlock)blockFactory.newConstantNullBlock(positionCount) : blockFactory.newConstantDoubleBlockWith(histogram.getMin(), positionCount);
                maxBlock = Double.isNaN(histogram.getMax()) ? (DoubleBlock)blockFactory.newConstantNullBlock(positionCount) : blockFactory.newConstantDoubleBlockWith(histogram.getMax(), positionCount);
                sumBlock = Double.isNaN(histogram.getSum()) ? (DoubleBlock)blockFactory.newConstantNullBlock(positionCount) : blockFactory.newConstantDoubleBlockWith(histogram.getSum(), positionCount);
                encodedDigestsBlock = blockFactory.newConstantBytesRefBlockWith(histogram.getEncodedDigest(), positionCount);
                success = true;
                tDigestArrayBlock = new TDigestArrayBlock(encodedDigestsBlock, minBlock, maxBlock, sumBlock, countBlock);
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    Releasables.close((Releasable[])new Releasable[]{minBlock, maxBlock, sumBlock, countBlock, encodedDigestsBlock});
                }
                throw throwable;
            }
            Releasables.close((Releasable[])new Releasable[]{minBlock, maxBlock, sumBlock, countBlock, encodedDigestsBlock});
        }
        return tDigestArrayBlock;
    }

    public boolean equals(Object o) {
        if (o instanceof TDigestBlock) {
            TDigestBlock block = (TDigestBlock)o;
            return TDigestBlock.equals(this, block);
        }
        return false;
    }

    boolean equalsAfterTypeCheck(TDigestArrayBlock that) {
        return this.minima.equals(that.minima) && this.maxima.equals(that.maxima) && this.sums.equals(that.sums) && this.valueCounts.equals(that.valueCounts) && this.encodedDigests.equals(that.encodedDigests);
    }

    public int hashCode() {
        return this.encodedDigests.hashCode();
    }
}

