/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopDoubleLongAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopDoubleLongGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopDoubleLongAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final int limit;
    private final boolean ascending;

    public TopDoubleLongAggregatorFunctionSupplier(int limit, boolean ascending) {
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return TopDoubleLongAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return TopDoubleLongGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public TopDoubleLongAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return TopDoubleLongAggregatorFunction.create(driverContext, channels, this.limit, this.ascending);
    }

    @Override
    public TopDoubleLongGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return TopDoubleLongGroupingAggregatorFunction.create(channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top_double of longs";
    }
}

