/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopDoubleIntAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopDoubleIntGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopDoubleIntAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final int limit;
    private final boolean ascending;

    public TopDoubleIntAggregatorFunctionSupplier(int limit, boolean ascending) {
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return TopDoubleIntAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return TopDoubleIntGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public TopDoubleIntAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return TopDoubleIntAggregatorFunction.create(driverContext, channels, this.limit, this.ascending);
    }

    @Override
    public TopDoubleIntGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return TopDoubleIntGroupingAggregatorFunction.create(channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top_double of ints";
    }
}

