/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.attachment;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.Tika;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.apache.tika.parser.epub.EpubParser;
import org.apache.tika.parser.html.JSoupParser;
import org.apache.tika.parser.iwork.IWorkPackageParser;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.OldExcelParser;
import org.apache.tika.parser.microsoft.ooxml.OOXMLParser;
import org.apache.tika.parser.microsoft.rtf.RTFParser;
import org.apache.tika.parser.odf.OpenDocumentParser;
import org.apache.tika.parser.pdf.PDFParser;
import org.apache.tika.parser.txt.TXTParser;
import org.apache.tika.parser.xml.DcXMLParser;

final class TikaImpl {
    private static final Set<MediaType> EXCLUDES = new HashSet<MediaType>(Arrays.asList(MediaType.application((String)"vnd.ms-visio.drawing"), MediaType.application((String)"vnd.ms-visio.drawing.macroenabled.12"), MediaType.application((String)"vnd.ms-visio.stencil"), MediaType.application((String)"vnd.ms-visio.stencil.macroenabled.12"), MediaType.application((String)"vnd.ms-visio.template"), MediaType.application((String)"vnd.ms-visio.template.macroenabled.12"), MediaType.application((String)"vnd.ms-visio.drawing")));
    private static final Parser[] PARSERS = new Parser[]{new JSoupParser(), new RTFParser(), new PDFParser(), new TXTParser(), new OfficeParser(), new OldExcelParser(), ParserDecorator.withoutTypes((Parser)new OOXMLParser(), EXCLUDES), new OpenDocumentParser(), new IWorkPackageParser(), new DcXMLParser(), new EpubParser()};
    private static final AutoDetectParser PARSER_INSTANCE = new AutoDetectParser(PARSERS);
    private static final Tika TIKA_INSTANCE = new Tika(PARSER_INSTANCE.getDetector(), (Parser)PARSER_INSTANCE);

    TikaImpl() {
    }

    static String parse(byte[] content, Metadata metadata, int limit) throws TikaException, IOException {
        try {
            return TIKA_INSTANCE.parseToString((InputStream)new ByteArrayInputStream(content), metadata, limit);
        }
        catch (LinkageError e) {
            if (e.getMessage().contains("bouncycastle")) {
                throw new RuntimeException("document is encrypted", e);
            }
            throw new RuntimeException(e);
        }
    }
}

