/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.server.cli;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import org.elasticsearch.Build;
import org.elasticsearch.bootstrap.ServerArgs;
import org.elasticsearch.cli.CliToolProvider;
import org.elasticsearch.cli.Command;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.cli.EnvironmentAwareCommand;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.env.Environment;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.server.cli.JvmOptionsParser;
import org.elasticsearch.server.cli.KeyStoreLoader;
import org.elasticsearch.server.cli.KeystorePasswordTerminal;
import org.elasticsearch.server.cli.MachineDependentHeap;
import org.elasticsearch.server.cli.SecureSettingsLoader;
import org.elasticsearch.server.cli.ServerProcess;
import org.elasticsearch.server.cli.ServerProcessBuilder;
import org.elasticsearch.server.cli.ServerProcessUtils;

class ServerCli
extends EnvironmentAwareCommand {
    private final OptionSpecBuilder versionOption;
    private final OptionSpecBuilder daemonizeOption;
    private final OptionSpec<Path> pidfileOption;
    private final OptionSpecBuilder quietOption;
    private final OptionSpec<String> enrollmentTokenOption;
    private final AtomicBoolean shuttingDown = new AtomicBoolean(false);
    private volatile ServerProcess server;

    ServerCli() {
        super("Starts Elasticsearch");
        this.versionOption = this.parser.acceptsAll(Arrays.asList("V", "version"), "Prints Elasticsearch version information and exits");
        this.daemonizeOption = this.parser.acceptsAll(Arrays.asList("d", "daemonize"), "Starts Elasticsearch in the background").availableUnless((OptionSpec)this.versionOption, new OptionSpec[0]);
        this.pidfileOption = this.parser.acceptsAll(Arrays.asList("p", "pidfile"), "Creates a pid file in the specified path on start").availableUnless((OptionSpec)this.versionOption, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        this.quietOption = this.parser.acceptsAll(Arrays.asList("q", "quiet"), "Turns off standard output/error streams logging in console").availableUnless((OptionSpec)this.versionOption, new OptionSpec[0]).availableUnless((OptionSpec)this.daemonizeOption, new OptionSpec[0]);
        this.enrollmentTokenOption = this.parser.accepts("enrollment-token", "An existing enrollment token for securely joining a cluster").availableUnless((OptionSpec)this.versionOption, new OptionSpec[0]).withRequiredArg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Terminal terminal, OptionSet options, Environment env, ProcessInfo processInfo) throws Exception {
        if (!options.nonOptionArguments().isEmpty()) {
            throw new UserException(64, "Positional arguments not allowed, found " + String.valueOf(options.nonOptionArguments()));
        }
        if (options.has((OptionSpec)this.versionOption)) {
            ServerCli.printVersion(terminal);
            return;
        }
        this.validateConfig(options, env);
        SecureSettingsLoader secureSettingsLoader = this.secureSettingsLoader(env);
        try (SecureSettingsLoader.LoadedSecrets loadedSecrets = secureSettingsLoader.load(env, terminal);
             SecureString password = loadedSecrets.password().isPresent() ? loadedSecrets.password().get() : new SecureString(new char[0]);){
            SecureSettings secrets = loadedSecrets.secrets();
            if (secureSettingsLoader.supportsSecurityAutoConfiguration()) {
                env = this.autoConfigureSecurity(terminal, options, processInfo, env, password);
                secrets = secureSettingsLoader.bootstrap(env, password);
            }
            if (secrets == null) {
                throw new UserException(78, "Elasticsearch secure settings not configured");
            }
            this.syncPlugins(terminal, env, processInfo);
            ServerArgs args = this.createArgs(options, env, secrets, processInfo);
            AtomicBoolean atomicBoolean = this.shuttingDown;
            synchronized (atomicBoolean) {
                block23: {
                    if (!this.shuttingDown.get()) break block23;
                    terminal.println((CharSequence)"CLI is shutting down, skipping starting server process");
                    return;
                }
                this.server = this.startServer(terminal, processInfo, args);
            }
        }
        if (options.has((OptionSpec)this.daemonizeOption)) {
            this.server.detach();
            return;
        }
        System.gc();
        int exitCode = this.server.waitFor();
        this.onExit(exitCode);
    }

    protected void onExit(int exitCode) throws UserException {
        if (exitCode != 0) {
            throw new UserException(exitCode, "Elasticsearch exited unexpectedly");
        }
    }

    private static void printVersion(Terminal terminal) {
        String versionOutput = String.format(Locale.ROOT, "Version: %s, Build: %s/%s/%s, JVM: %s", Build.current().qualifiedVersion(), Build.current().type().displayName(), Build.current().hash(), Build.current().date(), JvmInfo.jvmInfo().version());
        terminal.println((CharSequence)versionOutput);
    }

    private void validateConfig(OptionSet options, Environment env) throws UserException {
        if (options.valuesOf(this.enrollmentTokenOption).size() > 1) {
            throw new UserException(64, "Multiple --enrollment-token parameters are not allowed");
        }
        Path log4jConfig = env.configDir().resolve("log4j2.properties");
        if (!Files.exists(log4jConfig, new LinkOption[0])) {
            throw new UserException(78, "Missing logging config file at " + String.valueOf(log4jConfig));
        }
    }

    Environment autoConfigureSecurity(Terminal terminal, OptionSet options, ProcessInfo processInfo, Environment env, SecureString keystorePassword) throws Exception {
        assert (this.secureSettingsLoader(env) instanceof KeyStoreLoader);
        String autoConfigLibs = "modules/x-pack-core,modules/x-pack-security,lib/tools/security-cli";
        Command cmd = this.loadTool(processInfo.sysprops(), "auto-configure-node", autoConfigLibs);
        assert (cmd instanceof EnvironmentAwareCommand);
        EnvironmentAwareCommand autoConfigNode = (EnvironmentAwareCommand)cmd;
        String[] autoConfigArgs = options.has(this.enrollmentTokenOption) ? new String[]{"--enrollment-token", (String)options.valueOf(this.enrollmentTokenOption)} : new String[]{};
        OptionSet autoConfigOptions = autoConfigNode.parseOptions(autoConfigArgs);
        boolean changed = true;
        try (KeystorePasswordTerminal autoConfigTerminal = new KeystorePasswordTerminal(terminal, keystorePassword.clone());){
            autoConfigNode.execute((Terminal)autoConfigTerminal, autoConfigOptions, env, processInfo);
        }
        catch (UserException e) {
            boolean okCode;
            switch (e.exitCode) {
                case 73: 
                case 78: 
                case 80: {
                    boolean bl = true;
                    break;
                }
                default: {
                    boolean bl = okCode = false;
                }
            }
            if (!options.has(this.enrollmentTokenOption) && okCode) {
                if (e.getMessage() != null) {
                    terminal.errorPrintln(e.getMessage());
                }
                changed = false;
            }
            throw e;
        }
        if (changed) {
            env = this.createEnv(options, processInfo);
        }
        return env;
    }

    void syncPlugins(Terminal terminal, Environment env, ProcessInfo processInfo) throws Exception {
        String pluginCliLibs = "lib/tools/plugin-cli";
        Command cmd = this.loadTool(processInfo.sysprops(), "sync-plugins", pluginCliLibs);
        assert (cmd instanceof EnvironmentAwareCommand);
        EnvironmentAwareCommand syncPlugins = (EnvironmentAwareCommand)cmd;
        syncPlugins.execute(terminal, syncPlugins.parseOptions(new String[0]), env, processInfo);
    }

    private static void validatePidFile(Path pidFile) throws UserException {
        Path parent = pidFile.getParent();
        if (parent != null && Files.exists(parent, new LinkOption[0]) && !Files.isDirectory(parent, new LinkOption[0])) {
            throw new UserException(64, "pid file parent [" + String.valueOf(parent) + "] exists but is not a directory");
        }
        if (Files.exists(pidFile, new LinkOption[0]) && !Files.isRegularFile(pidFile, new LinkOption[0])) {
            throw new UserException(64, String.valueOf(pidFile) + " exists but is not a regular file");
        }
    }

    private ServerArgs createArgs(OptionSet options, Environment env, SecureSettings secrets, ProcessInfo processInfo) throws UserException {
        boolean daemonize = options.has((OptionSpec)this.daemonizeOption);
        boolean quiet = options.has((OptionSpec)this.quietOption);
        Path pidFile = null;
        if (options.has(this.pidfileOption)) {
            pidFile = (Path)options.valueOf(this.pidfileOption);
            if (!pidFile.isAbsolute()) {
                pidFile = processInfo.workingDir().resolve(pidFile.toString()).toAbsolutePath();
            }
            ServerCli.validatePidFile(pidFile);
        }
        return new ServerArgs(daemonize, quiet, pidFile, secrets, env.settings(), env.configDir(), env.logsDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        AtomicBoolean atomicBoolean = this.shuttingDown;
        synchronized (atomicBoolean) {
            this.shuttingDown.set(true);
            if (this.server != null) {
                this.server.stop();
            }
        }
    }

    protected ServerProcess getServer() {
        return this.server;
    }

    protected Command loadTool(Map<String, String> sysprops, String toolname, String libs) {
        return CliToolProvider.load(sysprops, (String)toolname, (String)libs).create();
    }

    protected ServerProcess startServer(Terminal terminal, ProcessInfo processInfo, ServerArgs args) throws Exception {
        Path tempDir = ServerProcessUtils.setupTempDir(processInfo);
        List<String> jvmOptions = JvmOptionsParser.determineJvmOptions(args, processInfo, tempDir, new MachineDependentHeap());
        ServerProcessBuilder serverProcessBuilder = new ServerProcessBuilder().withTerminal(terminal).withProcessInfo(processInfo).withServerArgs(args).withTempDir(tempDir).withJvmOptions(jvmOptions);
        return serverProcessBuilder.start();
    }

    protected SecureSettingsLoader secureSettingsLoader(Environment env) {
        return new KeyStoreLoader();
    }
}

