/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.io.IOException;
import org.apache.lucene.internal.hppc.IntArrayList;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.aggregatemetric.mapper.AggregateMetricDoubleFieldMapper;
import org.elasticsearch.xpack.downsample.AbstractDownsampleFieldProducer;
import org.elasticsearch.xpack.downsample.LastValueFieldProducer;

abstract sealed class NumericMetricFieldProducer
extends AbstractDownsampleFieldProducer<SortedNumericDoubleValues> {
    static final double MAX_NO_VALUE = -1.7976931348623157E308;
    static final double MIN_NO_VALUE = Double.MAX_VALUE;

    NumericMetricFieldProducer(String name) {
        super(name);
    }

    @Override
    public abstract void collect(SortedNumericDoubleValues var1, IntArrayList var2) throws IOException;

    public static AbstractDownsampleFieldProducer<?> createFieldProducerForGauge(String name, DownsampleConfig.SamplingMethod samplingMethod) {
        return switch (samplingMethod) {
            default -> throw new MatchException(null, null);
            case DownsampleConfig.SamplingMethod.AGGREGATE -> new AggregateGaugeMetricFieldProducer(name);
            case DownsampleConfig.SamplingMethod.LAST_VALUE -> LastValueFieldProducer.createForMetric(name);
        };
    }

    static final class AggregateGaugeMetricFieldProducer
    extends NumericMetricFieldProducer {
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        final CompensatedSum sum = new CompensatedSum();
        long count;

        AggregateGaugeMetricFieldProducer(String name) {
            super(name);
        }

        @Override
        public void collect(SortedNumericDoubleValues docValues, IntArrayList docIdBuffer) throws IOException {
            for (int i = 0; i < docIdBuffer.size(); ++i) {
                int docId = docIdBuffer.get(i);
                if (!docValues.advanceExact(docId)) continue;
                this.isEmpty = false;
                int docValuesCount = docValues.docValueCount();
                for (int j = 0; j < docValuesCount; ++j) {
                    double value = docValues.nextValue();
                    this.max = Math.max(value, this.max);
                    this.min = Math.min(value, this.min);
                    this.sum.add(value);
                    ++this.count;
                }
            }
        }

        @Override
        public void reset() {
            this.isEmpty = true;
            this.max = -1.7976931348623157E308;
            this.min = Double.MAX_VALUE;
            this.sum.reset(0.0, 0.0);
            this.count = 0L;
        }

        @Override
        public void write(XContentBuilder builder) throws IOException {
            if (!this.isEmpty()) {
                builder.startObject(this.name());
                builder.field("min", this.min);
                builder.field("max", this.max);
                builder.field("sum", this.sum.value());
                builder.field("value_count", this.count);
                builder.endObject();
            }
        }
    }

    static final class AggregateSubMetricFieldProducer
    extends NumericMetricFieldProducer {
        final AggregateMetricDoubleFieldMapper.Metric metric;
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        final CompensatedSum sum = new CompensatedSum();
        long count;

        AggregateSubMetricFieldProducer(String name, AggregateMetricDoubleFieldMapper.Metric metric) {
            super(name);
            this.metric = metric;
        }

        @Override
        public void collect(SortedNumericDoubleValues docValues, IntArrayList docIdBuffer) throws IOException {
            for (int i = 0; i < docIdBuffer.size(); ++i) {
                int docId = docIdBuffer.get(i);
                if (!docValues.advanceExact(docId)) continue;
                this.isEmpty = false;
                int docValuesCount = docValues.docValueCount();
                block7: for (int j = 0; j < docValuesCount; ++j) {
                    double value = docValues.nextValue();
                    switch (this.metric) {
                        case min: {
                            this.min = Math.min(value, this.min);
                            continue block7;
                        }
                        case max: {
                            this.max = Math.max(value, this.max);
                            continue block7;
                        }
                        case sum: {
                            this.sum.add(value);
                            continue block7;
                        }
                        case value_count: {
                            this.count += Math.round(value);
                        }
                    }
                }
            }
        }

        @Override
        public void reset() {
            this.isEmpty = true;
            this.max = -1.7976931348623157E308;
            this.min = Double.MAX_VALUE;
            this.sum.reset(0.0, 0.0);
            this.count = 0L;
        }

        @Override
        public void write(XContentBuilder builder) throws IOException {
            if (!this.isEmpty()) {
                builder.startObject(this.name());
                switch (this.metric) {
                    case min: {
                        builder.field("min", this.min);
                        break;
                    }
                    case max: {
                        builder.field("max", this.max);
                        break;
                    }
                    case sum: {
                        builder.field("sum", this.sum.value());
                        break;
                    }
                    case value_count: {
                        builder.field("value_count", this.count);
                    }
                }
                builder.endObject();
            }
        }
    }
}

