/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.internal.hppc.IntArrayList;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramXContent;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.HistogramValue;
import org.elasticsearch.index.mapper.flattened.FlattenedFieldSyntheticWriterHelper;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.aggregatemetric.mapper.AggregateMetricDoubleFieldMapper;
import org.elasticsearch.xpack.downsample.AbstractDownsampleFieldProducer;

class LastValueFieldProducer
extends AbstractDownsampleFieldProducer<FormattedDocValues> {
    private final boolean supportsMultiValue;
    Object lastValue = null;

    LastValueFieldProducer(String name, boolean producesMultiValue) {
        super(name);
        this.supportsMultiValue = producesMultiValue;
    }

    static LastValueFieldProducer createForLabel(String name, String fieldType) {
        assert (!"aggregate_metric_double".equals(fieldType)) : "field type cannot be aggregate metric double: " + fieldType + " for field " + name;
        if ("histogram".equals(fieldType)) {
            return new HistogramFieldProducer(name, true);
        }
        if ("exponential_histogram".equals(fieldType)) {
            return new ExponentialHistogramFieldProducer(name);
        }
        if ("flattened".equals(fieldType)) {
            return new FlattenedFieldProducer(name, true);
        }
        return new LastValueFieldProducer(name, true);
    }

    static LastValueFieldProducer createForMetric(String name) {
        return new LastValueFieldProducer(name, false);
    }

    static AggregateSubMetricFieldProducer createForAggregateSubMetricLabel(String name, AggregateMetricDoubleFieldMapper.Metric metric) {
        return new AggregateSubMetricFieldProducer(name, metric, true);
    }

    static AggregateSubMetricFieldProducer createForAggregateSubMetricMetric(String name, AggregateMetricDoubleFieldMapper.Metric metric) {
        return new AggregateSubMetricFieldProducer(name, metric, false);
    }

    @Override
    public void reset() {
        this.isEmpty = true;
        this.lastValue = null;
    }

    @Override
    public void collect(FormattedDocValues docValues, IntArrayList docIdBuffer) throws IOException {
        if (!this.isEmpty()) {
            return;
        }
        for (int i = 0; i < docIdBuffer.size(); ++i) {
            int docId = docIdBuffer.get(i);
            if (!docValues.advanceExact(docId)) continue;
            int docValuesCount = docValues.docValueCount();
            assert (docValuesCount > 0);
            this.isEmpty = false;
            if (docValuesCount == 1 || !this.supportsMultiValue) {
                this.lastValue = docValues.nextValue();
            } else {
                Object[] values = new Object[docValuesCount];
                for (int j = 0; j < docValuesCount; ++j) {
                    values[j] = docValues.nextValue();
                }
                this.lastValue = values;
            }
            return;
        }
    }

    @Override
    public void write(XContentBuilder builder) throws IOException {
        if (!this.isEmpty()) {
            builder.field(this.name(), this.lastValue);
        }
    }

    public Object lastValue() {
        return this.lastValue;
    }

    static final class HistogramFieldProducer
    extends LastValueFieldProducer {
        private HistogramFieldProducer(String name, boolean producesMultiValue) {
            super(name, producesMultiValue);
        }

        @Override
        public void write(XContentBuilder builder) throws IOException {
            if (!this.isEmpty()) {
                HistogramValue histogramValue = (HistogramValue)this.lastValue();
                ArrayList<Double> values = new ArrayList<Double>();
                ArrayList<Long> counts = new ArrayList<Long>();
                while (histogramValue.next()) {
                    values.add(histogramValue.value());
                    counts.add(histogramValue.count());
                }
                builder.startObject(this.name()).field("counts", counts).field("values", values).endObject();
            }
        }
    }

    static class ExponentialHistogramFieldProducer
    extends LastValueFieldProducer {
        ExponentialHistogramFieldProducer(String name) {
            super(name, false);
        }

        @Override
        public void write(XContentBuilder builder) throws IOException {
            if (!this.isEmpty()) {
                builder.field(this.name());
                ExponentialHistogramXContent.serialize((XContentBuilder)builder, (ExponentialHistogram)((ExponentialHistogram)this.lastValue()));
            }
        }
    }

    static final class FlattenedFieldProducer
    extends LastValueFieldProducer {
        private FlattenedFieldProducer(String name, boolean producesMultiValue) {
            super(name, producesMultiValue);
        }

        @Override
        public void write(XContentBuilder builder) throws IOException {
            if (!this.isEmpty()) {
                List<BytesRef> list;
                builder.startObject(this.name());
                Object value = this.lastValue();
                if (value instanceof Object[]) {
                    Object[] values = (Object[])value;
                    list = new ArrayList<BytesRef>(values.length);
                    for (Object v : values) {
                        list.add(new BytesRef((CharSequence)v.toString()));
                    }
                } else {
                    list = List.of(new BytesRef((CharSequence)value.toString()));
                }
                Iterator<BytesRef> iterator = list.iterator();
                FlattenedFieldSyntheticWriterHelper helper = new FlattenedFieldSyntheticWriterHelper(() -> {
                    if (iterator.hasNext()) {
                        return (BytesRef)iterator.next();
                    }
                    return null;
                });
                helper.write(builder);
                builder.endObject();
            }
        }
    }

    static final class AggregateSubMetricFieldProducer
    extends LastValueFieldProducer {
        private final AggregateMetricDoubleFieldMapper.Metric metric;

        private AggregateSubMetricFieldProducer(String name, AggregateMetricDoubleFieldMapper.Metric metric, boolean supportsMultiValue) {
            super(name, supportsMultiValue);
            this.metric = metric;
        }

        public String subMetric() {
            return this.metric.name();
        }
    }
}

