/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.internal.hppc.IntArrayList;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.xpack.downsample.LastValueFieldProducer;

public class DimensionFieldProducer
extends LastValueFieldProducer {
    DimensionFieldProducer(String name) {
        super(name, false);
    }

    void collectOnce(Object value) {
        assert (this.isEmpty);
        Objects.requireNonNull(value);
        this.lastValue = value;
        this.isEmpty = false;
    }

    boolean validate(FormattedDocValues docValues, IntArrayList buffer) throws IOException {
        for (int i = 0; i < buffer.size(); ++i) {
            int docId = buffer.get(i);
            if (!docValues.advanceExact(docId)) continue;
            int docValueCount = docValues.docValueCount();
            for (int j = 0; j < docValueCount; ++j) {
                Object value = docValues.nextValue();
                assert (value.equals(this.lastValue)) : "Dimension value changed without tsid change [" + String.valueOf(value) + "] != [" + String.valueOf(this.lastValue) + "]";
            }
        }
        return true;
    }

    @Override
    public void collect(FormattedDocValues docValues, IntArrayList docIdBuffer) throws IOException {
        if (!this.isEmpty()) {
            assert (this.validate(docValues, docIdBuffer));
            return;
        }
        for (int i = 0; i < docIdBuffer.size(); ++i) {
            int docId = docIdBuffer.get(i);
            if (!docValues.advanceExact(docId)) continue;
            int docValueCount = docValues.docValueCount();
            for (int j = 0; j < docValueCount; ++j) {
                this.collectOnce(docValues.nextValue());
            }
            return;
        }
    }
}

