/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins.cli;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.common.cli.EnvironmentAwareCommand;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.cli.InstallPluginAction;
import org.elasticsearch.plugins.cli.InstallablePlugin;
import org.elasticsearch.plugins.cli.SyncPluginsAction;

class InstallPluginCommand
extends EnvironmentAwareCommand {
    private final OptionSpec<Void> batchOption;
    private final OptionSpec<String> arguments;

    InstallPluginCommand() {
        super("Install a plugin");
        this.batchOption = this.parser.acceptsAll(Arrays.asList("b", "batch"), "Enable batch mode explicitly, automatic confirmation of security permission");
        this.arguments = this.parser.nonOptions("plugin id");
    }

    protected void printAdditionalHelp(Terminal terminal) {
        terminal.println((CharSequence)"The following official plugins may be installed by name:");
        for (String plugin : InstallPluginAction.OFFICIAL_PLUGINS) {
            terminal.println((CharSequence)("  " + plugin));
        }
        terminal.println((CharSequence)"");
    }

    public void execute(Terminal terminal, OptionSet options, Environment env, ProcessInfo processInfo) throws Exception {
        SyncPluginsAction.ensureNoConfigFile(env);
        List<InstallablePlugin> plugins = this.arguments.values(options).stream().map(idOrLocation -> new InstallablePlugin((String)idOrLocation, (String)idOrLocation)).collect(Collectors.toList());
        boolean isBatch = options.has(this.batchOption);
        try (InstallPluginAction action = new InstallPluginAction(terminal, env, isBatch);){
            action.execute(plugins);
        }
    }
}

