/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.Phase;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.action.ILMActions;
import org.elasticsearch.xpack.core.ilm.action.PutLifecycleRequest;

public class RestPutLifecycleAction
extends BaseRestHandler {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(RestPutLifecycleAction.class);
    public static final String MAX_SIZE_DEPRECATION_MESSAGE = "Use of the [max_size] rollover condition found in phase [{}]. This condition has been deprecated in favour of the [max_primary_shard_size] condition and will be removed in a later version";

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_ilm/policy/{name}"));
    }

    public String getName() {
        return "ilm_put_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest restRequest, NodeClient client) throws IOException {
        PutLifecycleRequest putLifecycleRequest;
        try (XContentParser parser = restRequest.contentParser();){
            putLifecycleRequest = PutLifecycleRequest.parseRequest((PutLifecycleRequest.Factory)new PutLifecycleRequest.Factory(){

                public PutLifecycleRequest create(LifecyclePolicy lifecyclePolicy) {
                    return new PutLifecycleRequest(RestUtils.getMasterNodeTimeout((RestRequest)restRequest), RestUtils.getAckTimeout((RestRequest)restRequest), lifecyclePolicy);
                }

                public String getPolicyName() {
                    return restRequest.param("name");
                }
            }, (XContentParser)parser);
        }
        for (Phase phase : putLifecycleRequest.getPolicy().getPhases().values()) {
            for (LifecycleAction actionObj : phase.getActions().values()) {
                RolloverAction rolloverAction;
                if (!(actionObj instanceof RolloverAction) || (rolloverAction = (RolloverAction)actionObj).getConditions().getMaxSize() == null) continue;
                DEPRECATION_LOGGER.warn(DeprecationCategory.API, "rollover-max-size-condition", MAX_SIZE_DEPRECATION_MESSAGE, new Object[]{phase.getName()});
            }
        }
        return channel -> client.execute(ILMActions.PUT, (ActionRequest)putLifecycleRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public Set<String> supportedCapabilities() {
        return Set.of("max_size_deprecation", "searchable_snapshot_force_merge_on_clone");
    }
}

