/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.models;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.UrlJwkProvider;
import io.jsonwebtoken.JweHeader;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.LocatorAdapter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Key;
import java.util.Objects;

public class DiscoverUrlAdapter
extends LocatorAdapter<Key> {
    private final JwkProvider keyStore;

    public DiscoverUrlAdapter(@Nonnull String keyDiscoveryUrl) throws URISyntaxException, MalformedURLException {
        this.keyStore = new UrlJwkProvider(new URI(Objects.requireNonNull(keyDiscoveryUrl)).toURL());
    }

    @Nullable
    protected Key locate(@Nonnull JwsHeader header) {
        Objects.requireNonNull(header);
        try {
            String keyId = header.getKeyId();
            Jwk publicKey = this.keyStore.get(keyId);
            return publicKey.getPublicKey();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not locate key", e);
        }
    }

    @Nullable
    protected Key locate(@Nonnull JweHeader header) {
        return null;
    }
}

