/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.settings;

import org.logstash.settings.Coercible;

public class BooleanSetting
extends Coercible<Boolean> {
    public BooleanSetting(String name, boolean defaultValue) {
        super(name, defaultValue, true, BooleanSetting.noValidator());
    }

    public BooleanSetting(String name, boolean defaultValue, boolean strict) {
        super(name, defaultValue, strict, BooleanSetting.noValidator());
    }

    @Override
    public Boolean coerce(Object obj) {
        if (obj instanceof String) {
            switch ((String)obj) {
                case "true": {
                    return true;
                }
                case "false": {
                    return false;
                }
            }
            throw new IllegalArgumentException(this.coercionFailureMessage(obj));
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        throw new IllegalArgumentException(this.coercionFailureMessage(obj));
    }

    private String coercionFailureMessage(Object obj) {
        return String.format("Cannot coerce `%s` to boolean (%s)", obj, this.getName());
    }
}

