/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.IsNullNode;
import org.apache.derby.impl.sql.compile.JoinNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class HalfOuterJoinNode
extends JoinNode {
    private boolean rightOuterJoin;
    private boolean transformed = false;

    HalfOuterJoinNode(ResultSetNode leftResult, ResultSetNode rightResult, ValueNode onClause, ResultColumnList usingClause, boolean rightOuterJoin, Properties tableProperties, ContextManager cm) throws StandardException {
        super(leftResult, rightResult, onClause, usingClause, null, tableProperties, null, cm);
        this.rightOuterJoin = rightOuterJoin;
        this.flattenableJoin = false;
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        FromTable leftFromTable = (FromTable)this.leftResultSet;
        if (leftFromTable.getReferencedTableMap().contains(optimizablePredicate.getReferencedMap())) {
            return leftFromTable.pushOptPredicate(optimizablePredicate);
        }
        return false;
    }

    @Override
    public String toString() {
        return "rightOuterJoin: " + this.rightOuterJoin + "\ntransformed: " + this.transformed + "\n" + super.toString();
    }

    @Override
    ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        if (this.rightOuterJoin) {
            SanityManager.ASSERT((!this.transformed ? 1 : 0) != 0, (String)"Attempting to transform a right outer join multiple times");
            ResultSetNode tmp = this.leftResultSet;
            this.leftResultSet = this.rightResultSet;
            this.rightResultSet = tmp;
            this.transformed = true;
        }
        ResultSetNode newTreeTop = super.preprocess(numTables, gbl, fromList);
        return newTreeTop;
    }

    @Override
    void pushExpressions(PredicateList outerPredicateList) throws StandardException {
        FromTable leftFromTable = (FromTable)this.leftResultSet;
        FromTable rightFromTable = (FromTable)this.rightResultSet;
        this.pushExpressionsToLeft(outerPredicateList);
        for (int index = this.joinPredicates.size() - 1; index >= 0; --index) {
            Predicate predicate = (Predicate)this.joinPredicates.elementAt(index);
            if (!predicate.getPushable()) continue;
            this.getRightPredicateList().addPredicate(predicate);
            this.joinPredicates.removeElementAt(index);
        }
        PredicateList noPredicates = new PredicateList(this.getContextManager());
        leftFromTable.pushExpressions(this.getLeftPredicateList());
        rightFromTable.pushExpressions(noPredicates);
    }

    @Override
    boolean LOJ_reorderable(int numTables) throws StandardException {
        ResultSetNode logicalRightResultSet;
        ResultSetNode logicalLeftResultSet;
        boolean anyChange = false;
        if (this.rightOuterJoin) {
            logicalLeftResultSet = this.rightResultSet;
            logicalRightResultSet = this.leftResultSet;
        } else {
            logicalLeftResultSet = this.leftResultSet;
            logicalRightResultSet = this.rightResultSet;
        }
        super.normExpressions();
        if (logicalLeftResultSet instanceof FromBaseTable && logicalRightResultSet instanceof FromBaseTable) {
            return anyChange;
        }
        if (logicalLeftResultSet instanceof HalfOuterJoinNode) {
            anyChange = ((HalfOuterJoinNode)logicalLeftResultSet).LOJ_reorderable(numTables) || anyChange;
        } else if (!(logicalLeftResultSet instanceof FromBaseTable)) {
            return anyChange;
        }
        if (logicalRightResultSet instanceof HalfOuterJoinNode) {
            anyChange = ((HalfOuterJoinNode)logicalRightResultSet).LOJ_reorderable(numTables) || anyChange;
        } else if (!(logicalRightResultSet instanceof FromBaseTable)) {
            return anyChange;
        }
        if (this.rightOuterJoin || logicalRightResultSet instanceof HalfOuterJoinNode && ((HalfOuterJoinNode)logicalRightResultSet).rightOuterJoin) {
            return this.LOJ_bindResultColumns(anyChange);
        }
        JBitSet RPReferencedTableMap = logicalLeftResultSet.LOJgetReferencedTables(numTables);
        JBitSet NPReferencedTableMap = logicalRightResultSet.LOJgetReferencedTables(numTables);
        if ((RPReferencedTableMap == null || NPReferencedTableMap == null) && anyChange) {
            return this.LOJ_bindResultColumns(anyChange);
        }
        if (logicalRightResultSet instanceof HalfOuterJoinNode) {
            JBitSet nestedChildOJRPRefTableMap = ((HalfOuterJoinNode)logicalRightResultSet).LOJgetRPReferencedTables(numTables);
            if (!this.isNullRejecting(this.joinClause, RPReferencedTableMap, nestedChildOJRPRefTableMap)) {
                return this.LOJ_bindResultColumns(anyChange);
            }
            JBitSet nestedChildOJNPRefTableMap = ((HalfOuterJoinNode)logicalRightResultSet).LOJgetNPReferencedTables(numTables);
            if (this.isNullRejecting(((HalfOuterJoinNode)logicalRightResultSet).joinClause, nestedChildOJRPRefTableMap, nestedChildOJNPRefTableMap)) {
                if (this.subqueryList.size() != 0 || ((JoinNode)logicalRightResultSet).subqueryList.size() != 0 || this.joinPredicates.size() != 0 || ((JoinNode)logicalRightResultSet).joinPredicates.size() != 0 || this.usingClause != null || ((JoinNode)logicalRightResultSet).usingClause != null) {
                    return this.LOJ_bindResultColumns(anyChange);
                }
                anyChange = true;
                ResultSetNode tmp = logicalLeftResultSet;
                ResultSetNode LChild = ((HalfOuterJoinNode)logicalRightResultSet).leftResultSet;
                ResultSetNode RChild = ((HalfOuterJoinNode)logicalRightResultSet).rightResultSet;
                ((HalfOuterJoinNode)logicalRightResultSet).rightResultSet = LChild;
                ((HalfOuterJoinNode)logicalRightResultSet).leftResultSet = tmp;
                ValueNode vn = this.joinClause;
                this.joinClause = ((HalfOuterJoinNode)logicalRightResultSet).joinClause;
                ((HalfOuterJoinNode)logicalRightResultSet).joinClause = vn;
                FromList localFromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
                this.leftResultSet = logicalRightResultSet;
                this.rightResultSet = RChild;
                ((HalfOuterJoinNode)this.leftResultSet).setResultColumns(null);
                ((JoinNode)this.leftResultSet).bindResultColumns(localFromList);
                boolean bl = ((HalfOuterJoinNode)this.leftResultSet).LOJ_reorderable(numTables);
            }
        }
        return this.LOJ_bindResultColumns(anyChange);
    }

    private boolean isNullRejecting(ValueNode joinClause, JBitSet leftTableMap, JBitSet rightTableMap) throws StandardException {
        ValueNode vn = joinClause;
        boolean foundPred = false;
        while (vn != null) {
            AndNode andNode = null;
            if (vn instanceof AndNode) {
                andNode = (AndNode)vn;
                vn = andNode.getLeftOperand();
            }
            if (vn instanceof BinaryRelationalOperatorNode) {
                BinaryRelationalOperatorNode relop = (BinaryRelationalOperatorNode)vn;
                ValueNode leftCol = relop.getLeftOperand();
                ValueNode rightCol = relop.getRightOperand();
                boolean leftFound = false;
                boolean rightFound = false;
                if (leftCol instanceof ColumnReference) {
                    if (leftTableMap.get(((ColumnReference)leftCol).getTableNumber())) {
                        leftFound = true;
                    } else if (rightTableMap.get(((ColumnReference)leftCol).getTableNumber())) {
                        rightFound = true;
                    } else {
                        return false;
                    }
                }
                if (rightCol instanceof ColumnReference) {
                    if (leftTableMap.get(((ColumnReference)rightCol).getTableNumber())) {
                        leftFound = true;
                    } else if (rightTableMap.get(((ColumnReference)rightCol).getTableNumber())) {
                        rightFound = true;
                    } else {
                        return false;
                    }
                }
                if (leftFound && rightFound) {
                    foundPred = true;
                }
            } else if (!(vn instanceof BooleanConstantNode) || !foundPred) {
                return false;
            }
            if (andNode != null) {
                vn = andNode.getRightOperand();
                continue;
            }
            vn = null;
        }
        return foundPred;
    }

    boolean LOJ_bindResultColumns(boolean anyChange) throws StandardException {
        if (anyChange) {
            this.setResultColumns(null);
            FromList localFromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
            this.bindResultColumns(localFromList);
        }
        return anyChange;
    }

    @Override
    FromTable transformOuterJoins(ValueNode predicateTree, int numTables) throws StandardException {
        ResultSetNode innerRS;
        if (predicateTree == null) {
            this.leftResultSet.notFlattenableJoin();
            this.rightResultSet.notFlattenableJoin();
            return this;
        }
        super.transformOuterJoins(predicateTree, numTables);
        if (this.rightOuterJoin) {
            SanityManager.ASSERT((!this.transformed ? 1 : 0) != 0, (String)"right OJ not expected to be transformed into left OJ yet");
            innerRS = this.leftResultSet;
        } else {
            innerRS = this.rightResultSet;
        }
        JBitSet innerMap = innerRS.LOJgetReferencedTables(numTables);
        ValueNode vn = predicateTree;
        while (vn instanceof AndNode) {
            AndNode and = (AndNode)vn;
            ValueNode left = and.getLeftOperand();
            if (left.getClass().equals(IsNullNode.class) && ((IsNullNode)left).isNullNode()) {
                vn = and.getRightOperand();
                continue;
            }
            if (left instanceof RelationalOperator) {
                JBitSet refMap = new JBitSet(numTables);
                if (!left.categorize(refMap, true)) {
                    vn = and.getRightOperand();
                    continue;
                }
                for (int bit = 0; bit < numTables; ++bit) {
                    if (!refMap.get(bit) || !innerMap.get(bit)) continue;
                    JoinNode ij = new JoinNode(this.leftResultSet, this.rightResultSet, this.joinClause, null, this.getResultColumns(), null, null, this.getContextManager());
                    ij.setTableNumber(this.tableNumber);
                    ij.setSubqueryList(this.subqueryList);
                    ij.setAggregates(this.aggregates);
                    return ij;
                }
            }
            vn = and.getRightOperand();
        }
        this.leftResultSet.notFlattenableJoin();
        this.rightResultSet.notFlattenableJoin();
        return this;
    }

    @Override
    protected void adjustNumberOfRowsReturned(CostEstimate costEstimate) {
        CostEstimate outerCost = this.getLeftResultSet().getCostEstimate();
        if (costEstimate.rowCount() < outerCost.rowCount()) {
            costEstimate.setCost(costEstimate.getEstimatedCost(), outerCost.rowCount(), outerCost.rowCount());
        }
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT((this.rightOuterJoin == this.transformed ? 1 : 0) != 0, (String)("rightOuterJoin (" + this.rightOuterJoin + ") is expected to equal transformed (" + this.transformed + ")"));
        super.generateCore(acb, mb, 3);
    }

    @Override
    int addOuterJoinArguments(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.rightResultSet.getResultColumns().generateNulls(acb, mb);
        mb.push(this.rightOuterJoin);
        return 2;
    }

    @Override
    protected int getNumJoinArguments() {
        return super.getNumJoinArguments() + 2;
    }

    @Override
    void oneRowRightSide(ActivationClassBuilder acb, MethodBuilder mb) {
        mb.push(false);
        mb.push(false);
    }

    @Override
    ResultSetNode getLogicalLeftResultSet() {
        if (this.rightOuterJoin) {
            return this.rightResultSet;
        }
        return this.leftResultSet;
    }

    @Override
    ResultSetNode getLogicalRightResultSet() {
        if (this.rightOuterJoin) {
            return this.leftResultSet;
        }
        return this.rightResultSet;
    }

    boolean isRightOuterJoin() {
        return this.rightOuterJoin;
    }

    @Override
    void isJoinColumnForRightOuterJoin(ResultColumn rc) {
        if (this.isRightOuterJoin() && this.usingClause != null && this.usingClause.getResultColumn(rc.getUnderlyingOrAliasName()) != null) {
            rc.setRightOuterJoinUsingClause(true);
            rc.setJoinResultset(this);
        }
    }

    JBitSet LOJgetNPReferencedTables(int numTables) throws StandardException {
        if (this.rightOuterJoin && !this.transformed) {
            return this.leftResultSet.LOJgetReferencedTables(numTables);
        }
        return this.rightResultSet.LOJgetReferencedTables(numTables);
    }

    public JBitSet LOJgetRPReferencedTables(int numTables) throws StandardException {
        if (this.rightOuterJoin && !this.transformed) {
            return this.rightResultSet.LOJgetReferencedTables(numTables);
        }
        return this.leftResultSet.LOJgetReferencedTables(numTables);
    }
}

