/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.GenericContainerWithVersion;
import io.confluent.kafka.serializers.KafkaAvroDeserializerConfig;
import io.confluent.kafka.serializers.NonRecordContainer;
import io.confluent.kafka.serializers.schema.id.SchemaId;
import io.confluent.kafka.serializers.schema.id.SchemaIdDeserializer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecord;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.header.Headers;

public abstract class AbstractKafkaAvroDeserializer
extends AbstractKafkaSchemaSerDe {
    private final DecoderFactory decoderFactory = DecoderFactory.get();
    protected boolean useSpecificAvroReader = false;
    protected Schema specificAvroReaderSchema = null;
    protected boolean avroReflectionAllowNull = false;
    protected boolean avroUseLogicalTypeConverters = false;
    private final Map<String, Schema> readerSchemaCache = new ConcurrentHashMap<String, Schema>();
    private final LoadingCache<IdentityPair<Schema, Schema>, DatumReader<?>> datumReaderCache;

    public AbstractKafkaAvroDeserializer() {
        CacheLoader cacheLoader = new CacheLoader<IdentityPair<Schema, Schema>, DatumReader<?>>(){

            public DatumReader<?> load(IdentityPair<Schema, Schema> key) {
                Schema writerSchema = key.getKey();
                Schema readerSchema = key.getValue();
                Schema finalReaderSchema = AbstractKafkaAvroDeserializer.this.getReaderSchema(writerSchema, readerSchema);
                boolean writerSchemaIsPrimitive = AvroSchemaUtils.getPrimitiveSchemas().containsValue(writerSchema);
                if (writerSchemaIsPrimitive) {
                    return new GenericDatumReader(writerSchema, finalReaderSchema, AvroSchemaUtils.getGenericData((boolean)AbstractKafkaAvroDeserializer.this.avroUseLogicalTypeConverters));
                }
                if (AbstractKafkaAvroDeserializer.this.useSchemaReflection) {
                    return new ReflectDatumReader(writerSchema, finalReaderSchema, AvroSchemaUtils.getReflectData((boolean)AbstractKafkaAvroDeserializer.this.avroUseLogicalTypeConverters, (boolean)AbstractKafkaAvroDeserializer.this.avroReflectionAllowNull));
                }
                if (AbstractKafkaAvroDeserializer.this.useSpecificAvroReader) {
                    return new SpecificDatumReader(writerSchema, finalReaderSchema, AvroSchemaUtils.getSpecificDataForSchema((Schema)finalReaderSchema, (boolean)AbstractKafkaAvroDeserializer.this.avroUseLogicalTypeConverters));
                }
                return new GenericDatumReader(writerSchema, finalReaderSchema, AvroSchemaUtils.getGenericData((boolean)AbstractKafkaAvroDeserializer.this.avroUseLogicalTypeConverters));
            }
        };
        this.datumReaderCache = CacheBuilder.newBuilder().maximumSize(1000L).build(cacheLoader);
    }

    protected void configure(KafkaAvroDeserializerConfig config) {
        this.configure(config, null);
    }

    protected void configure(KafkaAvroDeserializerConfig config, Class<?> type) {
        this.configureClientProperties(config, (SchemaProvider)new AvroSchemaProvider());
        this.useSpecificAvroReader = config.getBoolean("specific.avro.reader");
        if (this.useSpecificAvroReader && type != null) {
            try {
                this.specificAvroReaderSchema = ((SpecificRecord)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getSchema();
            }
            catch (Exception e) {
                throw new ConfigException(String.format("Error getting specificAvroReaderSchema from '%s'", type.getName()), (Object)e);
            }
        }
        this.avroReflectionAllowNull = config.getBoolean("avro.reflection.allow.null");
        this.avroUseLogicalTypeConverters = config.getBoolean("avro.use.logical.type.converters");
    }

    protected KafkaAvroDeserializerConfig deserializerConfig(Map<String, ?> props) {
        return new KafkaAvroDeserializerConfig(props);
    }

    protected KafkaAvroDeserializerConfig deserializerConfig(Properties props) {
        return new KafkaAvroDeserializerConfig(props);
    }

    protected Object deserialize(byte[] payload) throws SerializationException {
        return this.deserialize(null, this.isKey, payload, this.specificAvroReaderSchema);
    }

    protected Object deserialize(Headers headers, byte[] payload) throws SerializationException {
        return this.deserialize(null, this.isKey, headers, payload, this.specificAvroReaderSchema);
    }

    protected Object deserialize(byte[] payload, Schema readerSchema) throws SerializationException {
        return this.deserialize(null, this.isKey, payload, readerSchema);
    }

    protected Object deserialize(Headers headers, byte[] payload, Schema readerSchema) throws SerializationException {
        return this.deserialize(null, this.isKey, headers, payload, readerSchema);
    }

    protected Object deserialize(String topic, Boolean isKey, byte[] payload, Schema readerSchema) throws SerializationException {
        return this.deserialize(topic, isKey, null, payload, readerSchema);
    }

    protected Object deserialize(String topic, Boolean isKey, Headers headers, byte[] payload, Schema readerSchema) throws SerializationException {
        if (this.schemaRegistry == null) {
            throw new InvalidConfigurationException("SchemaRegistryClient not found. You need to configure the deserializer or use deserializer constructor with SchemaRegistryClient.");
        }
        if (payload == null) {
            return null;
        }
        DeserializationContext context = new DeserializationContext(topic, isKey, headers, payload);
        return context.read(context.schemaFromRegistry(), readerSchema != null ? new AvroSchema(readerSchema) : null);
    }

    private Integer schemaVersion(String topic, boolean isKey, SchemaId id, String subject, AvroSchema schema, Object result) {
        try {
            Integer version = null;
            AvroSchema subjectSchema = (AvroSchema)this.getSchemaBySchemaId(subject, id);
            Metadata metadata = subjectSchema.metadata();
            if (metadata != null) {
                version = metadata.getConfluentVersionNumber();
            }
            if (version == null) {
                version = this.schemaRegistry.getVersion(subject, (ParsedSchema)subjectSchema);
            }
            return version;
        }
        catch (InterruptedIOException e) {
            String errorMessage = "Error retrieving Avro " + AbstractKafkaAvroDeserializer.getSchemaType(isKey) + " schema version for id " + String.valueOf(id);
            throw new TimeoutException(errorMessage, (Throwable)e);
        }
        catch (IOException e) {
            throw new SerializationException("Error retrieving Avro " + AbstractKafkaAvroDeserializer.getSchemaType(isKey) + " schema version for id " + String.valueOf(id), (Throwable)e);
        }
        catch (RestClientException e) {
            String errorMessage = "Error retrieving Avro " + AbstractKafkaAvroDeserializer.getSchemaType(isKey) + " schema version for id " + String.valueOf(id);
            throw AbstractKafkaAvroDeserializer.toKafkaException((RestClientException)e, (String)errorMessage);
        }
    }

    private String subjectName(String topic, boolean isKey, AvroSchema schemaFromRegistry) {
        return this.getSubjectName(topic, isKey, null, (ParsedSchema)schemaFromRegistry);
    }

    protected GenericContainerWithVersion deserializeWithSchemaAndVersion(String topic, boolean isKey, byte[] payload) throws SerializationException, InvalidConfigurationException {
        return this.deserializeWithSchemaAndVersion(topic, isKey, null, payload);
    }

    protected GenericContainerWithVersion deserializeWithSchemaAndVersion(String topic, boolean isKey, Headers headers, byte[] payload) throws SerializationException, InvalidConfigurationException {
        if (payload == null) {
            return null;
        }
        DeserializationContext context = new DeserializationContext(topic, isKey, headers, payload);
        AvroSchema schema = context.schemaForDeserialize();
        Object result = context.read(schema, this.specificAvroReaderSchema != null ? new AvroSchema(this.specificAvroReaderSchema) : null);
        Integer version = this.schemaVersion(topic, isKey, context.getSchemaId(), context.getSubject(), schema, result);
        if (schema.rawSchema().getType().equals((Object)Schema.Type.RECORD)) {
            return new GenericContainerWithVersion((GenericContainer)result, version);
        }
        return new GenericContainerWithVersion(new NonRecordContainer(schema.rawSchema(), result), version);
    }

    protected DatumReader<?> getDatumReader(Schema writerSchema, Schema readerSchema) throws ExecutionException {
        return (DatumReader)this.datumReaderCache.get(new IdentityPair<Schema, Schema>(writerSchema, readerSchema));
    }

    private Schema getReaderSchema(Schema writerSchema, Schema readerSchema) {
        if (readerSchema != null) {
            return readerSchema;
        }
        boolean shouldSkipReaderSchemaCacheUsage = this.shouldSkipReaderSchemaCacheUsage(writerSchema);
        if (!shouldSkipReaderSchemaCacheUsage) {
            readerSchema = this.readerSchemaCache.get(writerSchema.getFullName());
        }
        if (readerSchema != null) {
            return readerSchema;
        }
        boolean writerSchemaIsPrimitive = AvroSchemaUtils.getPrimitiveSchemas().containsValue(writerSchema);
        if (writerSchemaIsPrimitive) {
            readerSchema = writerSchema;
        } else if (this.useSchemaReflection) {
            readerSchema = this.getReflectionReaderSchema(writerSchema);
            this.readerSchemaCache.put(writerSchema.getFullName(), readerSchema);
        } else if (this.useSpecificAvroReader) {
            readerSchema = this.getSpecificReaderSchema(writerSchema);
            if (!shouldSkipReaderSchemaCacheUsage) {
                this.readerSchemaCache.put(writerSchema.getFullName(), readerSchema);
            }
        } else {
            readerSchema = writerSchema;
        }
        return readerSchema;
    }

    private boolean shouldSkipReaderSchemaCacheUsage(Schema schema) {
        return this.useSpecificAvroReader && (schema.getType() == Schema.Type.ARRAY || schema.getType() == Schema.Type.MAP || schema.getType() == Schema.Type.UNION);
    }

    private Schema getSpecificReaderSchema(Schema writerSchema) {
        if (writerSchema.getType() == Schema.Type.ARRAY || writerSchema.getType() == Schema.Type.MAP || writerSchema.getType() == Schema.Type.UNION) {
            return writerSchema;
        }
        Class readerClass = SpecificData.get().getClass(writerSchema);
        if (readerClass == null) {
            throw new SerializationException("Could not find class " + writerSchema.getFullName() + " specified in writer's schema whilst finding reader's schema for a SpecificRecord.");
        }
        try {
            return ((SpecificRecord)readerClass.newInstance()).getSchema();
        }
        catch (InstantiationException e) {
            throw new SerializationException(writerSchema.getFullName() + " specified by the writers schema could not be instantiated to find the readers schema.");
        }
        catch (IllegalAccessException e) {
            throw new SerializationException(writerSchema.getFullName() + " specified by the writers schema is not allowed to be instantiated to find the readers schema.");
        }
    }

    private Schema getReflectionReaderSchema(Schema writerSchema) {
        ReflectData reflectData = AvroSchemaUtils.getReflectData((boolean)this.avroUseLogicalTypeConverters, (boolean)this.avroReflectionAllowNull);
        Class readerClass = reflectData.getClass(writerSchema);
        if (readerClass == null) {
            throw new SerializationException("Could not find class " + writerSchema.getFullName() + " specified in writer's schema whilst finding reader's schema for a reflected class.");
        }
        return reflectData.getSchema((Type)readerClass);
    }

    private static String getSchemaType(Boolean isKey) {
        if (isKey == null) {
            return "unknown";
        }
        if (isKey.booleanValue()) {
            return "key";
        }
        return "value";
    }

    class DeserializationContext {
        private final String topic;
        private final Boolean isKey;
        private final Headers headers;
        private final byte[] payload;
        private final ByteBuffer buffer;
        private final SchemaId schemaId;

        DeserializationContext(String topic, Boolean isKey, Headers headers, byte[] payload) {
            this.topic = topic;
            this.isKey = isKey;
            this.headers = headers;
            this.payload = payload;
            SchemaId schemaId = new SchemaId("AVRO");
            try (SchemaIdDeserializer schemaIdDeserializer = AbstractKafkaAvroDeserializer.this.schemaIdDeserializer(isKey);){
                this.buffer = schemaIdDeserializer.deserialize(topic, isKey.booleanValue(), headers, payload, schemaId);
                this.schemaId = schemaId;
            }
            catch (IOException e) {
                throw new SerializationException("Error deserializing Avro message for id " + String.valueOf(schemaId), (Throwable)e);
            }
        }

        AvroSchema schemaFromRegistry() {
            try {
                String subjectName = this.isKey == null || AbstractKafkaAvroDeserializer.this.strategyUsesSchema(this.isKey) ? this.getContext() : this.getSubject();
                return (AvroSchema)AbstractKafkaAvroDeserializer.this.getSchemaBySchemaId(subjectName, this.schemaId);
            }
            catch (InterruptedIOException e) {
                String errorMessage = "Error retrieving Avro " + AbstractKafkaAvroDeserializer.getSchemaType(this.isKey) + " schema for id " + String.valueOf(this.schemaId);
                throw new TimeoutException(errorMessage, (Throwable)e);
            }
            catch (IOException e) {
                throw new SerializationException("Error retrieving Avro " + AbstractKafkaAvroDeserializer.getSchemaType(this.isKey) + " schema for id " + String.valueOf(this.schemaId), (Throwable)e);
            }
            catch (RestClientException e) {
                String errorMessage = "Error retrieving Avro " + AbstractKafkaAvroDeserializer.getSchemaType(this.isKey) + " schema for id " + String.valueOf(this.schemaId);
                throw AbstractKafkaSchemaSerDe.toKafkaException((RestClientException)e, (String)errorMessage);
            }
        }

        AvroSchema schemaForDeserialize() {
            try {
                return (AvroSchema)AbstractKafkaAvroDeserializer.this.getSchemaBySchemaId(this.getSubject(), this.schemaId);
            }
            catch (InterruptedIOException e) {
                String errorMessage = "Error retrieving Avro " + AbstractKafkaAvroDeserializer.getSchemaType(this.isKey) + " schema for id " + String.valueOf(this.schemaId);
                throw new TimeoutException(errorMessage, (Throwable)e);
            }
            catch (IOException e) {
                throw new SerializationException("Error retrieving Avro " + AbstractKafkaAvroDeserializer.getSchemaType(this.isKey) + " schema for id " + String.valueOf(this.schemaId), (Throwable)e);
            }
            catch (RestClientException e) {
                String errorMessage = "Error retrieving Avro " + AbstractKafkaAvroDeserializer.getSchemaType(this.isKey) + " schema for id " + String.valueOf(this.schemaId);
                throw AbstractKafkaSchemaSerDe.toKafkaException((RestClientException)e, (String)errorMessage);
            }
        }

        String getSubject() {
            boolean usesSchema = AbstractKafkaAvroDeserializer.this.strategyUsesSchema(this.isKey);
            return AbstractKafkaAvroDeserializer.this.subjectName(this.topic, this.isKey, usesSchema ? this.schemaFromRegistry() : null);
        }

        String getContext() {
            return AbstractKafkaAvroDeserializer.this.getContextName(this.topic);
        }

        String getTopic() {
            return this.topic;
        }

        boolean isKey() {
            return this.isKey;
        }

        SchemaId getSchemaId() {
            return this.schemaId;
        }

        Object read(AvroSchema writerAvroSchema) {
            return this.read(writerAvroSchema, AbstractKafkaAvroDeserializer.this.specificAvroReaderSchema != null ? new AvroSchema(AbstractKafkaAvroDeserializer.this.specificAvroReaderSchema) : null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object read(AvroSchema writerAvroSchema, AvroSchema readerAvroSchema) {
            try {
                Object result;
                List migrations = Collections.emptyList();
                if (readerAvroSchema == null) {
                    if (AbstractKafkaAvroDeserializer.this.metadata != null) {
                        readerAvroSchema = (AvroSchema)AbstractKafkaAvroDeserializer.this.getLatestWithMetadata(this.getSubject()).getSchema();
                    } else if (AbstractKafkaAvroDeserializer.this.useLatestVersion) {
                        readerAvroSchema = (AvroSchema)AbstractKafkaAvroDeserializer.this.lookupLatestVersion(this.getSubject(), (ParsedSchema)writerAvroSchema, false).getSchema();
                    }
                    if (readerAvroSchema != null) {
                        writerAvroSchema = this.schemaForDeserialize();
                        Integer version = AbstractKafkaAvroDeserializer.this.schemaVersion(this.topic, this.isKey, this.schemaId, this.getSubject(), writerAvroSchema, null);
                        writerAvroSchema = writerAvroSchema.copy(version);
                        migrations = AbstractKafkaAvroDeserializer.this.getMigrations(this.getSubject(), (ParsedSchema)writerAvroSchema, (ParsedSchema)readerAvroSchema);
                    }
                }
                Schema writerSchema = writerAvroSchema.rawSchema();
                Schema readerSchema = readerAvroSchema != null ? readerAvroSchema.rawSchema() : null;
                DatumReader reader = !migrations.isEmpty() ? new DatumReader(writerSchema, writerSchema, AvroSchemaUtils.getGenericData((boolean)AbstractKafkaAvroDeserializer.this.avroUseLogicalTypeConverters)) : AbstractKafkaAvroDeserializer.this.getDatumReader(writerSchema, readerSchema);
                int length = this.buffer.remaining();
                if (writerSchema.getType().equals((Object)Schema.Type.BYTES)) {
                    byte[] bytes = new byte[length];
                    this.buffer.get(bytes, 0, length);
                    result = bytes;
                } else {
                    int start = this.buffer.position() + this.buffer.arrayOffset();
                    result = reader.read(null, (Decoder)AbstractKafkaAvroDeserializer.this.decoderFactory.binaryDecoder(this.buffer.array(), start, length, null));
                    if (writerSchema.getType().equals((Object)Schema.Type.STRING)) {
                        result = result.toString();
                    }
                }
                if (readerAvroSchema == null) {
                    readerAvroSchema = writerAvroSchema;
                }
                AvroSchemaUtils.setThreadLocalData((Schema)readerAvroSchema.rawSchema(), (boolean)AbstractKafkaAvroDeserializer.this.avroUseLogicalTypeConverters, (boolean)AbstractKafkaAvroDeserializer.this.avroReflectionAllowNull);
                try {
                    if (!migrations.isEmpty()) {
                        result = AbstractKafkaAvroDeserializer.this.executeMigrations(migrations, this.getSubject(), this.topic, this.headers, result);
                    }
                    if (result instanceof JsonNode) {
                        reader = AbstractKafkaAvroDeserializer.this.getDatumReader(readerAvroSchema.rawSchema(), readerAvroSchema.rawSchema());
                        result = AvroSchemaUtils.toObject((JsonNode)((JsonNode)result), (AvroSchema)readerAvroSchema, reader);
                    }
                    result = AbstractKafkaAvroDeserializer.this.executeRules(this.getSubject(), this.topic, this.headers, this.payload, RuleMode.READ, null, (ParsedSchema)readerAvroSchema, result);
                }
                finally {
                    AvroSchemaUtils.clearThreadLocalData();
                }
                Object object = result;
                return object;
            }
            catch (ExecutionException ex) {
                throw new SerializationException("Error deserializing Avro message for id " + String.valueOf(this.schemaId), ex.getCause());
            }
            catch (RestClientException | IOException | RuntimeException e) {
                throw new SerializationException("Error deserializing Avro message for id " + String.valueOf(this.schemaId), e);
            }
            finally {
                AbstractKafkaAvroDeserializer.this.postOp(this.payload);
            }
        }
    }

    static class IdentityPair<K, V> {
        private final K key;
        private final V value;

        public IdentityPair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdentityPair pair = (IdentityPair)o;
            return this.key == pair.key && this.value == pair.value;
        }

        public int hashCode() {
            return System.identityHashCode(this.key) + System.identityHashCode(this.value);
        }

        public String toString() {
            return "IdentityPair{key=" + String.valueOf(this.key) + ", value=" + String.valueOf(this.value) + "}";
        }
    }
}

