/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsPeer;
import org.bouncycastle.tls.CertificateStatusRequest;
import org.bouncycastle.tls.DefaultTlsDHGroupVerifier;
import org.bouncycastle.tls.DefaultTlsSRPConfigVerifier;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.OCSPStatusRequest;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientContext;
import org.bouncycastle.tls.TlsDHGroupVerifier;
import org.bouncycastle.tls.TlsECCUtils;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsPSK;
import org.bouncycastle.tls.TlsPSKIdentity;
import org.bouncycastle.tls.TlsSRPConfigVerifier;
import org.bouncycastle.tls.TlsSRPIdentity;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.util.Integers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AbstractTlsClient
extends AbstractTlsPeer
implements TlsClient {
    protected TlsClientContext context;
    protected ProtocolVersion[] protocolVersions;
    protected int[] cipherSuites;
    protected Vector supportedGroups;
    protected Vector supportedSignatureAlgorithms;
    protected Vector supportedSignatureAlgorithmsCert;

    public AbstractTlsClient(TlsCrypto tlsCrypto) {
        super(tlsCrypto);
    }

    protected boolean allowUnexpectedServerExtension(Integer n, byte[] byArray) throws IOException {
        switch (n) {
            case 10: {
                TlsExtensionsUtils.readSupportedGroupsExtension(byArray);
                return true;
            }
            case 11: {
                TlsExtensionsUtils.readSupportedPointFormatsExtension(byArray);
                return true;
            }
        }
        return false;
    }

    protected Vector getNamedGroupRoles() {
        Vector vector = TlsUtils.getNamedGroupRoles(this.getCipherSuites());
        Vector vector2 = this.supportedSignatureAlgorithms;
        Vector vector3 = this.supportedSignatureAlgorithmsCert;
        if (null == vector2 || TlsUtils.containsAnySignatureAlgorithm(vector2, (short)3) || null != vector3 && TlsUtils.containsAnySignatureAlgorithm(vector3, (short)3)) {
            TlsUtils.addToSet(vector, 3);
        }
        return vector;
    }

    protected void checkForUnexpectedServerExtension(Hashtable hashtable, Integer n) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(hashtable, n);
        if (byArray != null && !this.allowUnexpectedServerExtension(n, byArray)) {
            throw new TlsFatalAlert(47);
        }
    }

    protected byte[] getNewConnectionID() {
        return null;
    }

    @Override
    public TlsPSKIdentity getPSKIdentity() throws IOException {
        return null;
    }

    @Override
    public TlsSRPIdentity getSRPIdentity() throws IOException {
        return null;
    }

    @Override
    public TlsDHGroupVerifier getDHGroupVerifier() {
        return new DefaultTlsDHGroupVerifier();
    }

    @Override
    public TlsSRPConfigVerifier getSRPConfigVerifier() {
        return new DefaultTlsSRPConfigVerifier();
    }

    protected Vector getCertificateAuthorities() {
        return null;
    }

    protected Vector getProtocolNames() {
        return null;
    }

    protected CertificateStatusRequest getCertificateStatusRequest() {
        return new CertificateStatusRequest(1, new OCSPStatusRequest(null, null));
    }

    protected Vector getMultiCertStatusRequest() {
        return null;
    }

    protected Vector getSNIServerNames() {
        return null;
    }

    protected Vector getSupportedGroups(Vector vector) {
        TlsCrypto tlsCrypto = this.getCrypto();
        Vector vector2 = new Vector();
        if (vector.contains(Integers.valueOf((int)2))) {
            TlsUtils.addIfSupported(vector2, tlsCrypto, new int[]{29, 30});
        }
        if (vector.contains(Integers.valueOf((int)2)) || vector.contains(Integers.valueOf((int)3))) {
            TlsUtils.addIfSupported(vector2, tlsCrypto, new int[]{23, 24});
        }
        if (vector.contains(Integers.valueOf((int)1))) {
            TlsUtils.addIfSupported(vector2, tlsCrypto, new int[]{256, 257, 258});
        }
        return vector2;
    }

    protected Vector getSupportedSignatureAlgorithms() {
        return TlsUtils.getDefaultSupportedSignatureAlgorithms(this.context);
    }

    protected Vector getSupportedSignatureAlgorithmsCert() {
        return null;
    }

    protected Vector getTrustedCAIndication() {
        return null;
    }

    protected short[] getAllowedClientCertificateTypes() {
        return null;
    }

    protected short[] getAllowedServerCertificateTypes() {
        return null;
    }

    @Override
    public void init(TlsClientContext tlsClientContext) {
        this.context = tlsClientContext;
        this.protocolVersions = this.getSupportedVersions();
        this.cipherSuites = this.getSupportedCipherSuites();
    }

    @Override
    public ProtocolVersion[] getProtocolVersions() {
        return this.protocolVersions;
    }

    @Override
    public int[] getCipherSuites() {
        return this.cipherSuites;
    }

    @Override
    public void notifyHandshakeBeginning() throws IOException {
        super.notifyHandshakeBeginning();
        this.supportedGroups = null;
        this.supportedSignatureAlgorithms = null;
        this.supportedSignatureAlgorithmsCert = null;
    }

    @Override
    public TlsSession getSessionToResume() {
        return null;
    }

    @Override
    public Vector getExternalPSKs() {
        return null;
    }

    @Override
    public boolean isFallback() {
        return false;
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        Object[] objectArray;
        Vector vector;
        Vector vector2;
        Object object;
        Vector vector3;
        Object object2;
        Hashtable hashtable = new Hashtable();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Object object3 = this.getProtocolVersions();
        for (int i = 0; i < ((ProtocolVersion[])object3).length; ++i) {
            object2 = object3[i];
            if (TlsUtils.isTLSv13((ProtocolVersion)object2)) {
                bl = true;
            } else {
                bl2 = true;
            }
            bl3 |= ProtocolVersion.DTLSv12.equals((ProtocolVersion)object2);
        }
        object3 = this.getProtocolNames();
        if (object3 != null) {
            TlsExtensionsUtils.addALPNExtensionClient(hashtable, (Vector)object3);
        }
        if ((vector3 = this.getSNIServerNames()) != null) {
            TlsExtensionsUtils.addServerNameExtensionClient(hashtable, vector3);
        }
        if ((object2 = this.getCertificateStatusRequest()) != null) {
            TlsExtensionsUtils.addStatusRequestExtension(hashtable, (CertificateStatusRequest)object2);
        }
        if (bl && (object = this.getCertificateAuthorities()) != null) {
            TlsExtensionsUtils.addCertificateAuthoritiesExtension(hashtable, (Vector)object);
        }
        if (bl2) {
            TlsExtensionsUtils.addEncryptThenMACExtension(hashtable);
            object = this.getMultiCertStatusRequest();
            if (object != null) {
                TlsExtensionsUtils.addStatusRequestV2Extension(hashtable, (Vector)object);
            }
            if ((vector2 = this.getTrustedCAIndication()) != null) {
                TlsExtensionsUtils.addTrustedCAKeysExtensionClient(hashtable, vector2);
            }
        }
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed((ProtocolVersion)(object = this.context.getClientVersion()))) {
            vector2 = this.getSupportedSignatureAlgorithms();
            if (null != vector2 && !vector2.isEmpty()) {
                this.supportedSignatureAlgorithms = vector2;
                TlsExtensionsUtils.addSignatureAlgorithmsExtension(hashtable, vector2);
            }
            if (null != (vector = this.getSupportedSignatureAlgorithmsCert()) && !vector.isEmpty()) {
                this.supportedSignatureAlgorithmsCert = vector;
                TlsExtensionsUtils.addSignatureAlgorithmsCertExtension(hashtable, vector);
            }
        }
        if ((vector = this.getSupportedGroups(vector2 = this.getNamedGroupRoles())) != null && !vector.isEmpty()) {
            this.supportedGroups = vector;
            TlsExtensionsUtils.addSupportedGroupsExtension(hashtable, vector);
        }
        if (bl2 && (vector2.contains(Integers.valueOf((int)2)) || vector2.contains(Integers.valueOf((int)3)))) {
            TlsExtensionsUtils.addSupportedPointFormatsExtension(hashtable, new short[]{0});
        }
        if ((objectArray = this.getAllowedClientCertificateTypes()) != null && TlsUtils.containsNot(objectArray, 0, objectArray.length, (short)0)) {
            TlsExtensionsUtils.addClientCertificateTypeExtensionClient(hashtable, objectArray);
        }
        if ((objectArray = this.getAllowedServerCertificateTypes()) != null && TlsUtils.containsNot(objectArray, 0, objectArray.length, (short)0)) {
            TlsExtensionsUtils.addServerCertificateTypeExtensionClient(hashtable, objectArray);
        }
        if (bl3 && (objectArray = (Object[])this.getNewConnectionID()) != null) {
            TlsExtensionsUtils.addConnectionIDExtension(hashtable, (byte[])objectArray);
        }
        return hashtable;
    }

    @Override
    public Vector getEarlyKeyShareGroups() {
        if (null == this.supportedGroups || this.supportedGroups.isEmpty()) {
            return null;
        }
        if (this.supportedGroups.contains(Integers.valueOf((int)29))) {
            return TlsUtils.vectorOfOne(Integers.valueOf((int)29));
        }
        if (this.supportedGroups.contains(Integers.valueOf((int)23))) {
            return TlsUtils.vectorOfOne(Integers.valueOf((int)23));
        }
        return TlsUtils.vectorOfOne(this.supportedGroups.elementAt(0));
    }

    @Override
    public boolean shouldUseCompatibilityMode() {
        return true;
    }

    @Override
    public void notifyServerVersion(ProtocolVersion protocolVersion) throws IOException {
    }

    @Override
    public void notifySessionToResume(TlsSession tlsSession) {
    }

    @Override
    public void notifySessionID(byte[] byArray) {
    }

    @Override
    public void notifySelectedCipherSuite(int n) {
    }

    @Override
    public void notifySelectedPSK(TlsPSK tlsPSK) throws IOException {
    }

    @Override
    public void processServerExtensions(Hashtable hashtable) throws IOException {
        if (null == hashtable) {
            return;
        }
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        boolean bl = TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion());
        if (!bl) {
            this.checkForUnexpectedServerExtension(hashtable, TlsExtensionsUtils.EXT_signature_algorithms);
            this.checkForUnexpectedServerExtension(hashtable, TlsExtensionsUtils.EXT_signature_algorithms_cert);
            this.checkForUnexpectedServerExtension(hashtable, TlsExtensionsUtils.EXT_supported_groups);
            int n = securityParameters.getCipherSuite();
            if (TlsECCUtils.isECCCipherSuite(n)) {
                TlsExtensionsUtils.getSupportedPointFormatsExtension(hashtable);
            } else {
                this.checkForUnexpectedServerExtension(hashtable, TlsExtensionsUtils.EXT_ec_point_formats);
            }
            this.checkForUnexpectedServerExtension(hashtable, TlsExtensionsUtils.EXT_padding);
        }
    }

    @Override
    public void processServerSupplementalData(Vector vector) throws IOException {
        if (vector != null) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public Vector getClientSupplementalData() throws IOException {
        return null;
    }

    @Override
    public void notifyNewSessionTicket(NewSessionTicket newSessionTicket) throws IOException {
    }
}

