/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventhubs.AzureActiveDirectoryTokenProvider;
import com.microsoft.azure.eventhubs.EventHubClient;
import com.microsoft.azure.eventhubs.EventHubClientOptions;
import com.microsoft.azure.eventhubs.EventHubException;
import com.microsoft.azure.eventhubs.ITokenProvider;
import com.microsoft.azure.eventhubs.RetryPolicy;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;

abstract class EventHubClientFactory {
    protected ScheduledExecutorService executor;
    protected final EventHubClientOptions options;

    EventHubClientFactory(RetryPolicy retryPolicy) {
        this(new EventHubClientOptions().setRetryPolicy(retryPolicy));
    }

    EventHubClientFactory(EventHubClientOptions options) {
        this.options = options;
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    abstract CompletableFuture<EventHubClient> createEventHubClient() throws EventHubException, IOException;

    static class EHCFWithTokenProvider
    extends EventHubClientFactory {
        private final URI endpoint;
        private final String eventHubPath;
        private final ITokenProvider tokenProvider;

        EHCFWithTokenProvider(URI endpoint, String eventHubPath, ITokenProvider tokenProvider, EventHubClientOptions options) {
            super(options);
            this.endpoint = endpoint;
            this.eventHubPath = eventHubPath;
            this.tokenProvider = tokenProvider;
        }

        @Override
        public CompletableFuture<EventHubClient> createEventHubClient() throws EventHubException, IOException {
            return EventHubClient.createWithTokenProvider((URI)this.endpoint, (String)this.eventHubPath, (ITokenProvider)this.tokenProvider, (ScheduledExecutorService)this.executor, (EventHubClientOptions)this.options);
        }
    }

    static class EHCFWithAuthCallback
    extends EventHubClientFactory {
        private final URI endpoint;
        private final String eventHubPath;
        private final AzureActiveDirectoryTokenProvider.AuthenticationCallback authCallback;
        private final String authority;

        EHCFWithAuthCallback(URI endpoint, String eventHubPath, AzureActiveDirectoryTokenProvider.AuthenticationCallback authCallback, String authority, EventHubClientOptions options) {
            super(options);
            this.endpoint = endpoint;
            this.eventHubPath = eventHubPath;
            this.authCallback = authCallback;
            this.authority = authority;
        }

        @Override
        public CompletableFuture<EventHubClient> createEventHubClient() throws EventHubException, IOException {
            return EventHubClient.createWithAzureActiveDirectory((URI)this.endpoint, (String)this.eventHubPath, (AzureActiveDirectoryTokenProvider.AuthenticationCallback)this.authCallback, (String)this.authority, (ScheduledExecutorService)this.executor, (EventHubClientOptions)this.options);
        }
    }

    static class EHCFWithConnectionString
    extends EventHubClientFactory {
        private final String eventHubConnectionString;

        EHCFWithConnectionString(String eventHubConnectionString, RetryPolicy retryPolicy) {
            super(retryPolicy);
            this.eventHubConnectionString = eventHubConnectionString;
        }

        @Override
        public CompletableFuture<EventHubClient> createEventHubClient() throws EventHubException, IOException {
            return EventHubClient.createFromConnectionString((String)this.eventHubConnectionString, (RetryPolicy)this.options.getRetryPolicy(), (ScheduledExecutorService)this.executor);
        }
    }
}

