"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteTemplate = deleteTemplate;
exports.upsertTemplate = upsertTemplate;
var _retry = require("../helpers/retry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function upsertTemplate({
  esClient,
  template,
  logger
}) {
  try {
    await (0, _retry.retryTransientEsErrors)(() => esClient.indices.putIndexTemplate(template), {
      logger
    });
    logger.debug(() => `Installed index template: ${JSON.stringify(template)}`);
  } catch (error) {
    logger.error(`Error updating index template: ${error.message}`);
    throw error;
  }
}
async function deleteTemplate({
  esClient,
  name,
  logger
}) {
  try {
    await (0, _retry.retryTransientEsErrors)(() => esClient.indices.deleteIndexTemplate({
      name
    }, {
      ignore: [404]
    }), {
      logger
    });
  } catch (error) {
    logger.error(`Error deleting index template: ${error.message}`);
    throw error;
  }
}