module.exports = "## KQL Query Syntax Guide\n\n### Core Syntax Rule\n`field:value` - Search for `value` within the specified `field`\n\n### Key Principles\n\n#### 1. Finding Values\n- Find documents where any field matches any of the words/terms listed. The term must appear as it is in the document, e.g. this query `dark light` won’t match documents containing the word \"darker\".\n- Use and/or and parentheses to define that multiple terms need to appear. This query `orange and (dark or light)` would find all documents that have the term \"orange\" and either \"dark\" or \"light\" (or both) in it.\n- To find values only in specific fields you can put the field name before the value e.g. this query `title : our planet or title : dark` will only find document with the term \"our\" and \"planet\" in the title field, or document with the term \"dark\" in the title field.\n- Putting quotes around values makes sure they are found in that specific order (match a phrase) e.g. if you want to make sure to only find documents containing “our planet” and not “planet our” you’d need the following query: `title: \"our planet\"`\n\n#### 2. Wildcards\n- Use wildcards * to match just parts of a term/word, e.g. this query `dark*` will find anything beginning with \"dark\" like \"darker\", \"darkest\", \"darkness\", etc.\n- Wildcards can be used anywhere in a term/word. ⚡ Using a wildcard in front of a word can be rather slow and resource intensive for your Elasticsearch — use with care. e.g. d*k *les\n- Wildcards cannot be used when searching for phrases i.e. \"our plan*\" will not retrieve results containing \"our planet\".\n- Wildcards can be used for searching over multiple fields in KQL e.g. this query will search \"fakestreet\" in all fields beginning with \"user.address.\": `user.address.* : fakestreet`\n\n#### 3. Boolean Operators\n- `or`: Combines multiple conditions where at least one must match\n  - `message:\"dark cat\" or message:\"dark dog\"` returns documents with either matching phrase\n- `and`: Requires all conditions to match\n  - `body.text:another thing and message:dark*` returns documents that have both conditions\n- Operators are case-insensitive: `OR`, `or`, `And`, `AND` all work\n\n#### 4. Nested Field Access\n- Use dot notation for nested fields: `body.text:\"value\"` searches within the `text` field inside the `body` object\n- Can chain multiple levels: `body.metadata.author:\"John\"`\n\n### Query Construction Rules\n1. Always specify the field explicitly when you want to search within a specific field\n2. Use quotes for phrases containing spaces or special characters\n3. Parentheses group conditions: `(message:cat or message:\"dark dog\") and status:active`\n4. Default behavior without field: Searching just `\"dark cat\"` searches across all searchable fields\n\n### Examples Explained\n- `message:\"dark cat\" or message:\"dark dog\"` → Documents where message field match either phrase\n- `message:\"dark\"` → Documents where message field contains the word \"dark\"\n- `body.text:dark*` → Documents where body.text field contains the term starting with \"dark\", e.g. \"darkness\", \"darker\", \"dark\"\n- `body.text:\"another thing\" and (dark or darker)` → Documents having \"another thing\" matching phrase in the body.text field, and dark or darker word in the document.";
