"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSignificantEventsApi = useSignificantEventsApi;
var _reactHooks = require("@kbn/react-hooks");
var _use_kibana = require("./use_kibana");
var _default_query = require("../components/stream_detail_significant_events_view/add_significant_event_flyout/utils/default_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSignificantEventsApi({
  name,
  start,
  end
}) {
  const {
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    signal,
    abort,
    refresh
  } = (0, _reactHooks.useAbortController)();
  return {
    upsertQuery: async ({
      feature,
      kql,
      title,
      id
    }) => {
      const effectiveFeature = feature && feature.name === _default_query.NO_FEATURE.name ? undefined : feature;
      await streamsRepositoryClient.fetch('PUT /api/streams/{name}/queries/{queryId} 2023-10-31', {
        signal,
        params: {
          path: {
            name,
            queryId: id
          },
          body: {
            kql,
            title,
            feature: effectiveFeature
          }
        }
      });
    },
    removeQuery: async id => {
      await streamsRepositoryClient.fetch('DELETE /api/streams/{name}/queries/{queryId} 2023-10-31', {
        signal,
        params: {
          path: {
            name,
            queryId: id
          }
        }
      });
    },
    bulk: async operations => {
      await streamsRepositoryClient.fetch('POST /api/streams/{name}/queries/_bulk 2023-10-31', {
        signal,
        params: {
          path: {
            name
          },
          body: {
            operations
          }
        }
      });
    },
    generate: (connectorId, feature) => {
      return streamsRepositoryClient.stream(`POST /api/streams/{name}/significant_events/_generate 2023-10-31`, {
        signal,
        params: {
          path: {
            name
          },
          query: {
            connectorId,
            from: new Date(start).toString(),
            to: new Date(end).toString()
          },
          body: {
            feature
          }
        }
      });
    },
    abort: () => {
      abort();
      refresh();
    }
  };
}