"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRoutingFieldSuggestions = exports.useEnrichmentFieldSuggestions = void 0;
var _react = require("react");
var _use_stream_enrichment = require("../components/data_management/stream_detail_enrichment/state_management/stream_enrichment_state_machine/use_stream_enrichment");
var _selectors = require("../components/data_management/stream_detail_enrichment/state_management/simulation_state_machine/selectors");
var _use_stream_routing = require("../components/data_management/stream_detail_routing/state_management/stream_routing_state_machine/use_stream_routing");
var _selectors2 = require("../components/data_management/stream_detail_routing/state_management/stream_routing_state_machine/selectors");
var _field_suggestions = require("../components/data_management/stream_detail_enrichment/steps/blocks/action/utils/field_suggestions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook for providing field suggestions from enrichment simulation data - to be used with Enrichment only
 */
const useEnrichmentFieldSuggestions = () => {
  const previewRecords = (0, _use_stream_enrichment.useSimulatorSelector)(state => (0, _selectors.selectPreviewRecords)(state.context));
  const detectedFields = (0, _use_stream_enrichment.useSimulatorSelector)(state => {
    var _state$context$simula;
    return (_state$context$simula = state.context.simulation) === null || _state$context$simula === void 0 ? void 0 : _state$context$simula.detected_fields;
  });
  return (0, _react.useMemo)(() => {
    return (0, _field_suggestions.createFieldSuggestions)(previewRecords, detectedFields);
  }, [previewRecords, detectedFields]);
};

/**
 * Hook for providing field suggestions from routing samples data - to be used with Routing only
 */
exports.useEnrichmentFieldSuggestions = useEnrichmentFieldSuggestions;
const useRoutingFieldSuggestions = () => {
  const previewRecords = (0, _use_stream_routing.useStreamSamplesSelector)(snapshot => (0, _selectors2.selectPreviewDocuments)(snapshot.context));
  return (0, _react.useMemo)(() => {
    return (0, _field_suggestions.createFieldSuggestions)(previewRecords);
  }, [previewRecords]);
};
exports.useRoutingFieldSuggestions = useRoutingFieldSuggestions;