"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDocViewerSetup = void 0;
var _unifiedDocViewer = require("@kbn/unified-doc-viewer");
var _react = require("react");
var _use_kibana = require("./use_kibana");
var _doc_viewer_diff = require("../components/data_management/stream_detail_enrichment/doc_viewer_diff");
var _doc_viewer_json = require("../components/data_management/stream_detail_enrichment/doc_viewer_json");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDocViewerSetup = (includeDocViewDiff = false) => {
  const {
    dependencies
  } = (0, _use_kibana.useKibana)();
  const {
    unifiedDocViewer
  } = dependencies.start;
  return (0, _react.useMemo)(() => {
    const docViewers = unifiedDocViewer.registry.getAll();
    const viewers = [docViewers.find(docView => docView.id === 'doc_view_table'), _doc_viewer_json.docViewJson];
    if (includeDocViewDiff) {
      viewers.push(_doc_viewer_diff.docViewDiff);
    }
    return new _unifiedDocViewer.DocViewsRegistry(viewers);
  }, [unifiedDocViewer.registry, includeDocViewDiff]);
};
exports.useDocViewerSetup = useDocViewerSetup;