"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDiscardConfirm = void 0;
var _i18n = require("@kbn/i18n");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultMessage = _i18n.i18n.translate('xpack.streams.cancelModal.message', {
  defaultMessage: 'Are you sure you want to discard your changes?'
});
const useDiscardConfirm = (handler, options = {}) => {
  const {
    core
  } = (0, _use_kibana.useKibana)();
  const {
    message = defaultMessage,
    enabled = true,
    ...optionsOverride
  } = options;
  if (!enabled) return handler;
  return async (...args) => {
    const hasCancelled = await core.overlays.openConfirm(message, {
      buttonColor: 'danger',
      title: _i18n.i18n.translate('xpack.streams.cancelModal.title', {
        defaultMessage: 'Discard changes?'
      }),
      confirmButtonText: _i18n.i18n.translate('xpack.streams.cancelModal.confirm', {
        defaultMessage: 'Discard'
      }),
      cancelButtonText: _i18n.i18n.translate('xpack.streams.cancelModal.cancel', {
        defaultMessage: 'Keep editing'
      }),
      ...optionsOverride
    });
    if (hasCancelled) handler(...args);
  };
};
exports.useDiscardConfirm = useDiscardConfirm;