"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResolvedDefinitionName = useResolvedDefinitionName;
var _reactHooks = require("@kbn/react-hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useResolvedDefinitionName({
  streamsRepositoryClient,
  doc
}) {
  const flattenedDoc = doc.flattened;
  const index = doc.raw._index;
  const fallbackStreamName = getFallbackStreamName(flattenedDoc);
  return (0, _reactHooks.useAbortableAsync)(async ({
    signal
  }) => {
    var _definition$stream;
    if (!index) {
      return fallbackStreamName;
    }
    const definition = await streamsRepositoryClient.fetch('GET /internal/streams/_resolve_index', {
      signal,
      params: {
        query: {
          index
        }
      }
    });
    return definition === null || definition === void 0 ? void 0 : (_definition$stream = definition.stream) === null || _definition$stream === void 0 ? void 0 : _definition$stream.name;
  }, [streamsRepositoryClient, index, fallbackStreamName]);
}
function getFallbackStreamName(flattenedDoc) {
  const wiredStreamName = flattenedDoc['stream.name'];
  if (wiredStreamName) {
    return String(wiredStreamName);
  }
  const dsnsType = flattenedDoc['data_stream.type'];
  const dsnsDataset = flattenedDoc['data_stream.dataset'];
  const dsnsNamespace = flattenedDoc['data_stream.namespace'];
  if (dsnsType && dsnsDataset && dsnsNamespace) {
    return `${dsnsType}-${dsnsDataset}-${dsnsNamespace}`;
  }
  return undefined;
}