"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildDiscoverParams = buildDiscoverParams;
var _streamsSchema = require("@kbn/streams-schema");
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function buildDiscoverParams(query, definition, timeState) {
  const esqlQuery = (0, _streamsSchema.buildEsqlQuery)((0, _streamsSchema.getIndexPatternsForStream)(definition), query);
  return {
    timeRange: {
      from: timeState.timeRange.from,
      to: timeState.timeRange.to
    },
    query: {
      esql: esqlQuery
    },
    dataViewSpec: {
      id: (0, _uuid.v4)(),
      title: (0, _streamsSchema.getIndexPatternsForStream)(definition).join(','),
      name: definition.name,
      timeFieldName: '@timestamp',
      type: 'esql'
    },
    filters: [],
    interval: 'auto'
  };
}