"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoSignificantEventsEmptyState = NoSignificantEventsEmptyState;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _asset_image = require("../../asset_image");
var _feature_selector = require("../feature_selector");
var _use_ai_features = require("../add_significant_event_flyout/generated_flow_form/use_ai_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_significant_events_view/empty_state/empty_state.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function NoSignificantEventsEmptyState({
  onGenerateSuggestionsClick,
  onManualEntryClick,
  features,
  selectedFeatures,
  onFeaturesChange
}) {
  var _aiFeatures$genAiConn;
  const aiFeatures = (0, _use_ai_features.useAIFeatures)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    justifyContent: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
    type: "significantEventsEmptyState",
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.significantEvents.emptyState.title', {
    defaultMessage: 'Generate significant events'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    textAlign: "center",
    css: {
      maxWidth: 480
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.streams.significantEvents.emptyState.description', {
    defaultMessage: "A Significant Event is a single, ‘interesting’ log event identified by an automated rule as being important for understanding a system's behaviour. Select feature context, to generate suggestions."
  })), /*#__PURE__*/_react.default.createElement(_feature_selector.FeaturesSelector, {
    features: features,
    selectedFeatures: selectedFeatures,
    onFeaturesChange: onFeaturesChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "sparkles",
    fill: true,
    disabled: selectedFeatures.length === 0 || !(aiFeatures !== null && aiFeatures !== void 0 && (_aiFeatures$genAiConn = aiFeatures.genAiConnectors) !== null && _aiFeatures$genAiConn !== void 0 && _aiFeatures$genAiConn.selectedConnector),
    onClick: () => onGenerateSuggestionsClick(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.significantEvents.emptyState.generateSuggestionsButtonLabel', {
    defaultMessage: 'Generate suggestions'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onManualEntryClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.significantEvents.emptyState.manualEntryButtonLabel', {
    defaultMessage: 'Manual entry'
  }))));
}