"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditSignificantEventFlyout = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_timefilter = require("../../hooks/use_timefilter");
var _use_significant_events_api = require("../../hooks/use_significant_events_api");
var _use_kibana = require("../../hooks/use_kibana");
var _add_significant_event_flyout = require("./add_significant_event_flyout/add_significant_event_flyout");
var _get_stream_type_from_definition = require("../../util/get_stream_type_from_definition");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_significant_events_view/edit_significant_event_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EditSignificantEventFlyout = ({
  queryToEdit,
  definition,
  isEditFlyoutOpen,
  setIsEditFlyoutOpen,
  initialFlow,
  selectedFeatures,
  setSelectedFeatures,
  setQueryToEdit,
  features,
  refresh
}) => {
  const {
    core: {
      notifications
    },
    services: {
      telemetryClient
    }
  } = (0, _use_kibana.useKibana)();
  const {
    timeState: {
      start,
      end
    }
  } = (0, _use_timefilter.useTimefilter)();
  const {
    upsertQuery,
    bulk
  } = (0, _use_significant_events_api.useSignificantEventsApi)({
    name: definition.stream.name,
    start,
    end
  });
  return isEditFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_add_significant_event_flyout.AddSignificantEventFlyout, {
    definition: definition.stream,
    query: queryToEdit,
    onSave: async data => {
      const streamType = (0, _get_stream_type_from_definition.getStreamTypeFromDefinition)(definition.stream);
      switch (data.type) {
        case 'single':
          await upsertQuery(data.query).then(() => {
            notifications.toasts.addSuccess({
              title: _i18n.i18n.translate('xpack.streams.significantEvents.savedSingle.successfullyToastTitle', {
                defaultMessage: `Saved significant event query successfully`
              })
            });
            telemetryClient.trackSignificantEventsCreated({
              count: 1,
              stream_type: streamType
            });
            setIsEditFlyoutOpen(false);
            refresh();
          }, error => {
            notifications.showErrorDialog({
              title: _i18n.i18n.translate('xpack.streams.significantEvents.savedSingle.errorToastTitle', {
                defaultMessage: `Could not save significant event query`
              }),
              error
            });
          });
          break;
        case 'multiple':
          await bulk(data.queries.map(query => ({
            index: query
          }))).then(() => {
            notifications.toasts.addSuccess({
              title: _i18n.i18n.translate('xpack.streams.significantEvents.savedMultiple.successfullyToastTitle', {
                defaultMessage: `Saved significant events queries successfully`
              })
            });
            telemetryClient.trackSignificantEventsCreated({
              count: data.queries.length,
              stream_type: streamType
            });
            setIsEditFlyoutOpen(false);
            refresh();
          }, error => {
            notifications.showErrorDialog({
              title: _i18n.i18n.translate('xpack.streams.significantEvents.savedMultiple.errorToastTitle', {
                defaultMessage: 'Could not save significant events queries'
              }),
              error
            });
          });
          break;
      }
    },
    onClose: () => {
      setIsEditFlyoutOpen(false);
      setQueryToEdit(undefined);
      setSelectedFeatures([]);
    },
    initialFlow: initialFlow,
    initialSelectedFeatures: selectedFeatures,
    features: features,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }) : null;
};
exports.EditSignificantEventFlyout = EditSignificantEventFlyout;