"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AIFeaturesDisabledCallout = AIFeaturesDisabledCallout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_significant_events_view/add_significant_event_flyout/generated_flow_form/ai_features_disabled_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AIFeaturesDisabledCallout({
  couldBeEnabled
}) {
  const {
    core: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.aiFlow.aiAssistantNotEnabledTooltip', {
      defaultMessage: 'AI Assistant features are not enabled. To enable features, add an AI connector on the management page.'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 9
    }
  }, couldBeEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: http.basePath.prepend(`/app/management/insightsAndAlerting/triggersActionsConnectors/connectors`),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.aiFlow.aiAssistantNotEnabled', {
    defaultMessage: 'Enable AI Assistant features'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.streams.addSignificantEventFlyout.aiFlow.aiAssistantNotEnabledAskAdmin', {
    defaultMessage: 'Ask your administrator to enable AI Assistant features'
  }))))));
}