"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toDataTableRecordWithIndex = exports.routingConverter = exports.processCondition = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _streamlang = require("@kbn/streamlang");
var _condition = require("../../../util/condition");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createId = (0, _eui.htmlIdGenerator)();
const toUIDefinition = routingDefinition => {
  var _routingDefinition$st;
  return {
    id: createId(),
    status: (_routingDefinition$st = routingDefinition.status) !== null && _routingDefinition$st !== void 0 ? _routingDefinition$st : 'enabled',
    ...routingDefinition
  };
};
const toAPIDefinition = routingDefinitionWithAttributes => {
  return (0, _lodash.omit)(routingDefinitionWithAttributes, 'id');
};
const routingConverter = exports.routingConverter = {
  toAPIDefinition,
  toUIDefinition
};
const processCondition = condition => {
  if (!condition) return undefined;
  const convertedCondition = (0, _condition.emptyEqualsToAlways)(condition);
  return convertedCondition && (0, _streamlang.isAlwaysCondition)(convertedCondition) ? undefined : convertedCondition;
};

// Convert SampleDocument[] to DataTableRecordWithIndex[] for flyout compatibility
exports.processCondition = processCondition;
const toDataTableRecordWithIndex = documents => documents.map((doc, index) => ({
  raw: doc,
  flattened: doc,
  index,
  id: `${index}-${Date.now()}`
}));
exports.toDataTableRecordWithIndex = toDataTableRecordWithIndex;