"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReviewSuggestionsForm = ReviewSuggestionsForm;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
var _nested_view = require("../../../nested_view");
var _generate_suggestions_button = require("./generate_suggestions_button");
var _suggested_stream_panel = require("./suggested_stream_panel");
var _stream_routing_state_machine = require("../state_management/stream_routing_state_machine");
var _create_stream_confirmation_modal = require("./create_stream_confirmation_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_routing/review_suggestions_form/review_suggestions_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ReviewSuggestionsForm({
  definition,
  aiFeatures,
  resetForm,
  suggestions,
  isLoadingSuggestions,
  previewSuggestion,
  acceptSuggestion,
  rejectSuggestion,
  onRegenerate
}) {
  const ruleUnderReview = (0, _stream_routing_state_machine.useStreamsRoutingSelector)(snapshot => snapshot.matches({
    ready: 'reviewSuggestedRule'
  }) ? snapshot.context.suggestedRuleId : null);
  const selectedPreviewName = (0, _stream_routing_state_machine.useStreamSamplesSelector)(({
    context
  }) => context.selectedPreview && context.selectedPreview.type === 'suggestion' && context.selectedPreview.name);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ruleUnderReview && /*#__PURE__*/_react.default.createElement(_create_stream_confirmation_modal.CreateStreamConfirmationModal, {
    partition: suggestions.find(({
      name
    }) => name === ruleUnderReview),
    onSuccess: () => acceptSuggestion(suggestions.findIndex(({
      name
    }) => name === ruleUnderReview)),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.streams.reviewSuggestionsForm.euiCallOut.reviewPartitioningSuggestionsLabel', {
      defaultMessage: 'Review partitioning suggestions'
    }),
    onDismiss: resetForm,
    className: (0, _css.css)`
          min-block-size: auto; /* Prevent background clipping */
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.childStreamList.suggestPartitionsDescription', {
    defaultMessage: 'Preview each suggestion before accepting - They will change how your data is ingested. All suggestions are based on the same sample: each proposal uses 1,000 documents from the original stream.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }), suggestions.map((partition, index) => /*#__PURE__*/_react.default.createElement(_nested_view.NestedView, {
    key: partition.name,
    last: index === suggestions.length - 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_suggested_stream_panel.SuggestedStreamPanel, {
    definition: definition,
    partition: partition,
    onPreview: toggle => previewSuggestion(index, toggle),
    onDismiss: () => rejectSuggestion(index, selectedPreviewName === partition.name),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_generate_suggestions_button.GenerateSuggestionButton, {
    iconType: "refresh",
    size: "s",
    onClick: onRegenerate,
    isLoading: isLoadingSuggestions,
    aiFeatures: aiFeatures,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.childStreamList.regenerateSuggestedPartitions', {
    defaultMessage: 'Regenerate'
  }))));
}