"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WiredStreamDetailManagement = WiredStreamDetailManagement;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_streams_app_params = require("../../../hooks/use_streams_app_params");
var _redirect_to = require("../../redirect_to");
var _stream_detail_routing = require("../stream_detail_routing");
var _stream_detail_schema_editor = require("../stream_detail_schema_editor");
var _stream_detail_lifecycle = require("../stream_detail_lifecycle");
var _wrapper = require("./wrapper");
var _use_streams_detail_management_tabs = require("./use_streams_detail_management_tabs");
var _wired_advanced_view = require("./wired_advanced_view");
var _stream_data_quality = require("../../stream_data_quality");
var _streams_app_page_template = require("../../streams_app_page_template");
var _stream_badges = require("../../stream_badges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_management/wired.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const wiredStreamManagementSubTabs = ['partitioning', 'processing', 'schema', 'retention', 'advanced', 'significantEvents', 'dataQuality', 'references'];
const tabRedirects = {
  schemaEditor: {
    newTab: 'schema'
  },
  lifecycle: {
    newTab: 'retention'
  },
  route: {
    newTab: 'partitioning'
  },
  enrich: {
    newTab: 'processing'
  }
};
function isValidManagementSubTab(value) {
  return wiredStreamManagementSubTabs.includes(value);
}
function WiredStreamDetailManagement({
  definition,
  refreshDefinition
}) {
  const {
    path: {
      key,
      tab
    }
  } = (0, _use_streams_app_params.useStreamsAppParams)('/{key}/management/{tab}');
  const {
    processing,
    isLoading,
    ...otherTabs
  } = (0, _use_streams_detail_management_tabs.useStreamsDetailManagementTabs)({
    definition,
    refreshDefinition
  });
  if (!definition.privileges.view_index_metadata) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_streams_app_page_template.StreamsAppPageTemplate.Header, {
      bottomBorder: "extended",
      pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 13
        }
      }, key, /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
        gutterSize: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_stream_badges.WiredStreamBadge, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 17
        }
      }))),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_streams_app_page_template.StreamsAppPageTemplate.Body, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: _i18n.i18n.translate('xpack.streams.wiredStreamOverview.noPrivileges.title', {
        defaultMessage: "Data stream couldn't be loaded"
      }),
      color: "danger",
      iconType: "error",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.streams.wiredStreamOverview.noPrivileges.description', {
      defaultMessage: "You don't have the required privileges to view this stream. Make sure you have sufficient view_index_metadata privileges."
    })))));
  }
  const tabs = {
    retention: {
      content: /*#__PURE__*/_react.default.createElement(_stream_detail_lifecycle.StreamDetailLifecycle, {
        definition: definition,
        refreshDefinition: refreshDefinition,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 9
        }
      }),
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: _i18n.i18n.translate('xpack.streams.managementTab.lifecycle.tooltip', {
          defaultMessage: 'Control how long data stays in this stream. Set a custom duration or apply a shared policy.'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        tabIndex: 0,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.streams.streamDetailView.lifecycleTab', {
        defaultMessage: 'Retention'
      })))
    },
    partitioning: {
      content: /*#__PURE__*/_react.default.createElement(_stream_detail_routing.StreamDetailRouting, {
        definition: definition,
        refreshDefinition: refreshDefinition,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 9
        }
      }),
      label: _i18n.i18n.translate('xpack.streams.streamDetailView.routingTab', {
        defaultMessage: 'Partitioning'
      })
    },
    processing,
    schema: {
      content: /*#__PURE__*/_react.default.createElement(_stream_detail_schema_editor.StreamDetailSchemaEditor, {
        definition: definition,
        refreshDefinition: refreshDefinition,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 9
        }
      }),
      label: _i18n.i18n.translate('xpack.streams.streamDetailView.schemaEditorTab', {
        defaultMessage: 'Schema'
      })
    },
    dataQuality: {
      content: /*#__PURE__*/_react.default.createElement(_stream_data_quality.StreamDetailDataQuality, {
        definition: definition,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 16
        }
      }),
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.streams.managementTab.dataQuality.wired.tooltip', {
          defaultMessage: 'View details about this stream’s data quality'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "dataQualityTab",
        tabIndex: 0,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.streams.streamDetailView.qualityTab', {
        defaultMessage: 'Data quality'
      })))
    },
    ...otherTabs,
    ...(definition.privileges.manage ? {
      advanced: {
        content: /*#__PURE__*/_react.default.createElement(_wired_advanced_view.WiredAdvancedView, {
          definition: definition,
          refreshDefinition: refreshDefinition,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 156,
            columnNumber: 15
          }
        }),
        label: _i18n.i18n.translate('xpack.streams.streamDetailView.advancedTab', {
          defaultMessage: 'Advanced'
        })
      }
    } : {})
  };
  const redirectConfig = tabRedirects[tab];
  if (redirectConfig) {
    return /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
      path: "/{key}/management/{tab}",
      params: {
        path: {
          key,
          tab: redirectConfig.newTab
        }
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 7
      }
    });
  }
  if (isValidManagementSubTab(tab)) {
    return /*#__PURE__*/_react.default.createElement(_wrapper.Wrapper, {
      tabs: tabs,
      streamId: key,
      tab: tab,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 12
      }
    });
  }
  if (isLoading) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
    path: "/{key}/management/{tab}",
    params: {
      path: {
        key,
        tab: 'partitioning'
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 5
    }
  });
}