"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStreamsDetailManagementTabs = useStreamsDetailManagementTabs;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_streams_privileges = require("../../../hooks/use_streams_privileges");
var _stream_detail_significant_events_view = require("../../stream_detail_significant_events_view");
var _stream_detail_enrichment = require("../stream_detail_enrichment");
var _stream_detail_references_view = require("../../stream_detail_references_view/stream_detail_references_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_management/use_streams_detail_management_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function useStreamsDetailManagementTabs({
  definition,
  refreshDefinition
}) {
  const {
    features: {
      significantEvents,
      groupStreams
    },
    isLoading
  } = (0, _use_streams_privileges.useStreamsPrivileges)();
  const isSignificantEventsEnabled = !!(significantEvents !== null && significantEvents !== void 0 && significantEvents.available);
  return {
    isLoading,
    processing: {
      content: /*#__PURE__*/_react.default.createElement(_stream_detail_enrichment.StreamDetailEnrichment, {
        definition: definition,
        refreshDefinition: refreshDefinition,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 33,
          columnNumber: 9
        }
      }),
      label: _i18n.i18n.translate('xpack.streams.streamDetailView.processingTab', {
        defaultMessage: 'Processing'
      })
    },
    ...(groupStreams !== null && groupStreams !== void 0 && groupStreams.enabled ? {
      references: {
        content: /*#__PURE__*/_react.default.createElement(_stream_detail_references_view.StreamDetailReferencesView, {
          definition: definition,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 42,
            columnNumber: 22
          }
        }),
        label: _i18n.i18n.translate('xpack.streams.streamDetailView.referencesTab', {
          defaultMessage: 'References'
        })
      }
    } : {}),
    ...(isSignificantEventsEnabled ? {
      significantEvents: {
        content: /*#__PURE__*/_react.default.createElement(_stream_detail_significant_events_view.StreamDetailSignificantEventsView, {
          definition: definition,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 52,
            columnNumber: 22
          }
        }),
        label: _i18n.i18n.translate('xpack.streams.streamDetailView.significantEventsTab', {
          defaultMessage: 'Significant events'
        })
      }
    } : {})
  };
}