"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnmanagedElasticsearchAssets = UnmanagedElasticsearchAssets;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_streams_privileges = require("../../../hooks/use_streams_privileges");
var _stream_feature_configuration = require("./stream_feature_configuration");
var _use_streams_app_fetch = require("../../../hooks/use_streams_app_fetch");
var _use_kibana = require("../../../hooks/use_kibana");
var _component_template_panel = require("./component_template_panel");
var _index_template_details = require("./index_template_details");
var _ingest_pipeline_details = require("./ingest_pipeline_details");
var _data_stream_details = require("./data_stream_details");
var _index_configuration = require("./advanced_view/index_configuration");
var _delete_stream = require("./advanced_view/delete_stream");
var _row = require("./advanced_view/row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_management/unmanaged_elasticsearch_assets.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function UnmanagedElasticsearchAssets({
  definition,
  refreshDefinition
}) {
  var _unmanagedAssetsDetai, _unmanagedAssetsDetai2, _unmanagedAssetsDetai3, _unmanagedAssetsDetai4;
  const {
    appParams: {
      history
    },
    dependencies: {
      start: {
        indexManagement,
        ingestPipelines,
        share,
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    features: {
      significantEvents
    }
  } = (0, _use_streams_privileges.useStreamsPrivileges)();
  const unmanagedAssetsDetailsFetch = (0, _use_streams_app_fetch.useStreamsAppFetch)(({
    signal
  }) => {
    return streamsRepositoryClient.fetch('GET /internal/streams/{name}/_unmanaged_assets', {
      signal,
      params: {
        path: {
          name: definition.stream.name
        }
      }
    });
  }, [definition.stream.name, streamsRepositoryClient]);
  const indexManagementLocator = share.url.locators.get('INDEX_MANAGEMENT_LOCATOR_ID');
  const [currentFlyout, setCurrentFlyout] = (0, _react.useState)(undefined);
  const ComponentTemplateFlyout = (0, _react.useMemo)(() => indexManagement.getComponentTemplateFlyoutComponent({
    history
  }), [history, indexManagement]);
  const DatastreamFlyout = (0, _react.useMemo)(() => indexManagement.getDatastreamFlyoutComponent({
    history
  }), [history, indexManagement]);
  const IndexTemplateFlyout = (0, _react.useMemo)(() => indexManagement.getIndexTemplateFlyoutComponent({
    history
  }), [history, indexManagement]);
  const IngestPipelineFlyout = (0, _react.useMemo)(() => ingestPipelines.getIngestPipelineFlyoutComponent({
    history
  }), [history, ingestPipelines]);
  if (!definition.data_stream_exists) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: _i18n.i18n.translate('xpack.streams.unmanagedStreamOverview.missingDatastream.title', {
        defaultMessage: 'Data stream missing'
      }),
      color: "danger",
      iconType: "error",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.unmanagedStreamOverview.missingDatastream.description', {
      defaultMessage: 'The underlying Elasticsearch data stream for this classic stream is missing or not accessible because the view_index_metadata privilege is missing. Make sure you have sufficient privileges and the data stream actually exists.'
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }, (significantEvents === null || significantEvents === void 0 ? void 0 : significantEvents.available) && /*#__PURE__*/_react.default.createElement(_stream_feature_configuration.StreamFeatureConfiguration, {
    definition: definition.stream,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_index_configuration.IndexConfiguration, {
    definition: definition,
    refreshDefinition: refreshDefinition,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_row.Row, {
    left: /*#__PURE__*/_react.default.createElement(_row.RowMetadata, {
      label: _i18n.i18n.translate('xpack.streams.streamDetailView.unmanagedStreamOverview.indexTemplateTitle', {
        defaultMessage: 'Index template'
      }),
      description: _i18n.i18n.translate('xpack.streams.streamDetailView.unmanagedStreamOverview.indexTemplateDescription', {
        defaultMessage: 'Use composable index and component templates to automatically apply settings, mappings, and aliases to indices'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 15
      }
    }),
    right: /*#__PURE__*/_react.default.createElement(_index_template_details.IndexTemplateDetails, {
      indexTemplate: (_unmanagedAssetsDetai = unmanagedAssetsDetailsFetch.value) === null || _unmanagedAssetsDetai === void 0 ? void 0 : _unmanagedAssetsDetai.indexTemplate,
      onFlyoutOpen: name => setCurrentFlyout({
        type: 'index_template',
        name
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_row.Row, {
    left: /*#__PURE__*/_react.default.createElement(_row.RowMetadata, {
      label: _i18n.i18n.translate('xpack.streams.streamDetailView.unmanagedStreamOverview.pipelineTitle', {
        defaultMessage: 'Pipeline'
      }),
      description: '',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 15
      }
    }),
    right: /*#__PURE__*/_react.default.createElement(_ingest_pipeline_details.IngestPipelineDetails, {
      ingestPipeline: (_unmanagedAssetsDetai2 = unmanagedAssetsDetailsFetch.value) === null || _unmanagedAssetsDetai2 === void 0 ? void 0 : _unmanagedAssetsDetai2.ingestPipeline,
      onFlyoutOpen: name => setCurrentFlyout({
        type: 'ingest_pipeline',
        name
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_row.Row, {
    left: /*#__PURE__*/_react.default.createElement(_row.RowMetadata, {
      label: _i18n.i18n.translate('xpack.streams.streamDetailView.unmanagedStreamOverview.dataStreamTitle', {
        defaultMessage: 'Data stream'
      }),
      description: _i18n.i18n.translate('xpack.streams.streamDetailView.unmanagedStreamOverview.dataStreamDescription', {
        defaultMessage: 'Data streams store time-series data across multiple indices and can be created from index templates'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 15
      }
    }),
    right: /*#__PURE__*/_react.default.createElement(_data_stream_details.DataStreamDetails, {
      indexManagementLocator: indexManagementLocator,
      dataStream: (_unmanagedAssetsDetai3 = unmanagedAssetsDetailsFetch.value) === null || _unmanagedAssetsDetai3 === void 0 ? void 0 : _unmanagedAssetsDetai3.dataStream,
      onFlyoutOpen: name => setCurrentFlyout({
        type: 'data_stream',
        name
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_component_template_panel.ComponentTemplatePanel, {
    componentTemplates: (_unmanagedAssetsDetai4 = unmanagedAssetsDetailsFetch.value) === null || _unmanagedAssetsDetai4 === void 0 ? void 0 : _unmanagedAssetsDetai4.componentTemplates,
    onFlyoutOpen: name => setCurrentFlyout({
      type: 'component_template',
      name
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_delete_stream.DeleteStreamPanel, {
    definition: definition,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  })), currentFlyout && currentFlyout.type === 'component_template' && /*#__PURE__*/_react.default.createElement(ComponentTemplateFlyout, {
    onClose: () => setCurrentFlyout(undefined),
    componentTemplateName: currentFlyout.name,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 9
    }
  }), currentFlyout && currentFlyout.type === 'data_stream' && /*#__PURE__*/_react.default.createElement(DatastreamFlyout, {
    onClose: () => setCurrentFlyout(undefined),
    datastreamName: currentFlyout.name,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 9
    }
  }), currentFlyout && currentFlyout.type === 'index_template' && /*#__PURE__*/_react.default.createElement(IndexTemplateFlyout, {
    onClose: () => setCurrentFlyout(undefined),
    indexTemplateName: currentFlyout.name,
    reload: refreshDefinition,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 9
    }
  }), currentFlyout && currentFlyout.type === 'ingest_pipeline' && /*#__PURE__*/_react.default.createElement(IngestPipelineFlyout, {
    onClose: () => setCurrentFlyout(undefined),
    ingestPipelineName: currentFlyout.name,
    reload: refreshDefinition,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 9
    }
  }));
}