"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupStreamDetailManagement = GroupStreamDetailManagement;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _use_streams_privileges = require("../../../hooks/use_streams_privileges");
var _use_streams_app_params = require("../../../hooks/use_streams_app_params");
var _redirect_to = require("../../redirect_to");
var _wrapper = require("./wrapper");
var _stream_detail_references_view = require("../../stream_detail_references_view/stream_detail_references_view");
var _linked_dashboards_view = require("./linked_dashboards_view");
var _group_stream_detail_view = require("./group_stream_detail_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_management/group.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const groupStreamManagementSubTabs = ['overview', 'dashboards', 'references'];
function isValidManagementSubTab(value) {
  return groupStreamManagementSubTabs.includes(value);
}
function GroupStreamDetailManagement({
  definition
}) {
  const {
    features: {
      groupStreams
    }
  } = (0, _use_streams_privileges.useStreamsPrivileges)();
  const {
    path: {
      key,
      tab
    }
  } = (0, _use_streams_app_params.useStreamsAppParams)('/{key}/management/{tab}');
  if (!(groupStreams !== null && groupStreams !== void 0 && groupStreams.enabled)) {
    return /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
      path: "/",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 12
      }
    });
  }
  const tabs = {
    overview: {
      content: /*#__PURE__*/_react.default.createElement(_group_stream_detail_view.GroupStreamDetailView, {
        stream: definition,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 45,
          columnNumber: 16
        }
      }),
      label: _i18n.i18n.translate('xpack.streams.streamDetailView.overviewTab', {
        defaultMessage: 'Overview'
      })
    },
    references: {
      content: /*#__PURE__*/_react.default.createElement(_stream_detail_references_view.StreamDetailReferencesView, {
        definition: definition,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 16
        }
      }),
      label: _i18n.i18n.translate('xpack.streams.streamDetailView.referencesTab', {
        defaultMessage: 'References'
      })
    },
    dashboards: {
      content: /*#__PURE__*/_react.default.createElement(_linked_dashboards_view.LinkedDashboardsView, {
        definition: definition,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 16
        }
      }),
      label: _i18n.i18n.translate('xpack.streams.streamDetailView.dashboardsTab', {
        defaultMessage: 'Dashboards'
      })
    }
  };
  if (!isValidManagementSubTab(tab) || tabs[tab] === undefined) {
    return /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
      path: "/{key}/management/{tab}",
      params: {
        path: {
          key,
          tab: 'overview'
        }
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_wrapper.Wrapper, {
    tabs: tabs,
    streamId: key,
    tab: tab,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 10
    }
  });
}