"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClassicStreamDetailManagement = ClassicStreamDetailManagement;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_streams_app_params = require("../../../hooks/use_streams_app_params");
var _redirect_to = require("../../redirect_to");
var _wrapper = require("./wrapper");
var _stream_detail_lifecycle = require("../stream_detail_lifecycle");
var _unmanaged_elasticsearch_assets = require("./unmanaged_elasticsearch_assets");
var _streams_app_page_template = require("../../streams_app_page_template");
var _stream_badges = require("../../stream_badges");
var _use_streams_detail_management_tabs = require("./use_streams_detail_management_tabs");
var _stream_data_quality = require("../../stream_data_quality");
var _stream_detail_schema_editor = require("../stream_detail_schema_editor");
var _stream_description = require("./stream_description");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_management/classic.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const classicStreamManagementSubTabs = ['processing', 'advanced', 'dataQuality', 'retention', 'significantEvents', 'schemaEditor', 'schema', 'references'];
const tabRedirects = {
  schemaEditor: {
    newTab: 'schema'
  },
  lifecycle: {
    newTab: 'retention'
  },
  enrich: {
    newTab: 'processing'
  }
};
function isValidManagementSubTab(value) {
  return classicStreamManagementSubTabs.includes(value);
}
function ClassicStreamDetailManagement({
  definition,
  refreshDefinition
}) {
  const {
    path: {
      key,
      tab
    }
  } = (0, _use_streams_app_params.useStreamsAppParams)('/{key}/management/{tab}');
  const {
    processing,
    isLoading,
    ...otherTabs
  } = (0, _use_streams_detail_management_tabs.useStreamsDetailManagementTabs)({
    definition,
    refreshDefinition
  });
  if (!definition.data_stream_exists) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_streams_app_page_template.StreamsAppPageTemplate.Header, {
      bottomBorder: "extended",
      pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 13
        }
      }, key, /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
        gutterSize: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_stream_badges.ClassicStreamBadge, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_stream_badges.LifecycleBadge, {
        lifecycle: definition.effective_lifecycle,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 17
        }
      }))),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_streams_app_page_template.StreamsAppPageTemplate.Body, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: _i18n.i18n.translate('xpack.streams.unmanagedStreamOverview.missingDatastream.title', {
        defaultMessage: 'Data stream missing'
      }),
      color: "danger",
      iconType: "error",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.streams.unmanagedStreamOverview.missingDatastream.description', {
      defaultMessage: 'The underlying Elasticsearch data stream for this classic stream is missing or not accessible because the view_index_metadata privilege is missing. Make sure you have sufficient privileges and the data stream actually exists.'
    })))));
  }
  const tabs = {};
  if (definition.data_stream_exists) {
    tabs.retention = {
      content: /*#__PURE__*/_react.default.createElement(_stream_detail_lifecycle.StreamDetailLifecycle, {
        definition: definition,
        refreshDefinition: refreshDefinition,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 9
        }
      }),
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.streams.managementTab.lifecycle.tooltip', {
          defaultMessage: 'Control how long data stays in this stream. Set a custom duration or apply a shared policy.'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        tabIndex: 0,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.streams.streamDetailView.lifecycleTab', {
        defaultMessage: 'Retention'
      })))
    };
    tabs.processing = processing;
  }
  tabs.schema = {
    content: /*#__PURE__*/_react.default.createElement(_stream_detail_schema_editor.StreamDetailSchemaEditor, {
      definition: definition,
      refreshDefinition: refreshDefinition,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 7
      }
    }),
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.schemaEditorTab', {
      defaultMessage: 'Schema'
    })
  };
  tabs.dataQuality = {
    content: /*#__PURE__*/_react.default.createElement(_stream_data_quality.StreamDetailDataQuality, {
      definition: definition,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 14
      }
    }),
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.streams.managementTab.dataQuality.tooltip', {
        defaultMessage: 'View details about this classic stream’s data quality'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "dataQualityTab",
      tabIndex: 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.qualityTab', {
      defaultMessage: 'Data quality'
    })))
  };
  if (otherTabs.significantEvents) {
    tabs.significantEvents = otherTabs.significantEvents;
  }
  if (definition.privileges.manage) {
    tabs.advanced = {
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, otherTabs.significantEvents ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_stream_description.StreamDescription, {
        definition: definition,
        refreshDefinition: refreshDefinition,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 164,
          columnNumber: 15
        }
      })) : null, /*#__PURE__*/_react.default.createElement(_unmanaged_elasticsearch_assets.UnmanagedElasticsearchAssets, {
        definition: definition,
        refreshDefinition: refreshDefinition,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 11
        }
      })),
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.streams.managementTab.advanced.tooltip', {
          defaultMessage: 'View technical details about this classic stream’s underlying index setup'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        tabIndex: 0,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.streams.streamDetailView.advancedTab', {
        defaultMessage: 'Advanced'
      })))
    };
  }
  if (isValidManagementSubTab(tab)) {
    return /*#__PURE__*/_react.default.createElement(_wrapper.Wrapper, {
      tabs: tabs,
      streamId: key,
      tab: tab,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 12
      }
    });
  }
  const redirectConfig = tabRedirects[tab];
  if (redirectConfig) {
    return /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
      path: "/{key}/management/{tab}",
      params: {
        path: {
          key,
          tab: redirectConfig.newTab
        }
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 7
      }
    });
  }
  if (isLoading) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_wrapper.Wrapper, {
    tabs: tabs,
    streamId: key,
    tab: tab,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 10
    }
  });
}