"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimeSizeAndUnitLabel = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timeUnitsLabels = {
  d: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.daysLabel', {
    defaultMessage: 'days'
  }),
  h: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.hoursLabel', {
    defaultMessage: 'hours'
  }),
  m: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.minutesLabel', {
    defaultMessage: 'minutes'
  }),
  s: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.secondsLabel', {
    defaultMessage: 'seconds'
  }),
  ms: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.msLabel', {
    defaultMessage: 'milliseconds'
  }),
  micros: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.microsLabel', {
    defaultMessage: 'microseconds'
  }),
  nanos: _i18n.i18n.translate('xpack.streams.streamDetailView.timeUnits.nanosLabel', {
    defaultMessage: 'nanoseconds'
  })
};
const splitSizeAndUnits = field => {
  let size = '';
  let unit = '';
  const result = /(\d+)(\w+)/.exec(field);
  if (result) {
    size = result[1];
    unit = result[2];
  }
  return {
    size,
    unit
  };
};
const getTimeSizeAndUnitLabel = value => {
  if (!value) return undefined;
  const {
    size,
    unit
  } = splitSizeAndUnits(value);
  const unitLabel = timeUnitsLabels[unit];
  return unitLabel ? `${size} ${unitLabel}` : value;
};
exports.getTimeSizeAndUnitLabel = getTimeSizeAndUnitLabel;