"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditLifecycleModal = EditLifecycleModal;
var _react = _interopRequireWildcard(require("react"));
var _streamsSchema = require("@kbn/streams-schema");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ilm = require("./ilm");
var _dsl2 = require("./dsl");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_lifecycle/general_data/modal/modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function EditLifecycleModal({
  closeModal,
  updateLifecycle,
  getIlmPolicies,
  definition,
  updateInProgress
}) {
  var _dsl$data_retention, _dsl;
  const {
    isServerless
  } = (0, _use_kibana.useKibana)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const isCurrentLifecycleInherit = (0, _streamsSchema.isInheritLifecycle)(definition.stream.ingest.lifecycle);
  const initialSelectedAction = (0, _streamsSchema.isIlmLifecycle)(definition.effective_lifecycle) ? 'ilm' : (0, _streamsSchema.isDslLifecycle)(definition.effective_lifecycle) && !definition.effective_lifecycle.dsl.data_retention ? 'indefinite' : 'custom';
  const [isInheritToggleOn, setIsInheritToggleOn] = (0, _react.useState)(isCurrentLifecycleInherit);
  const [selectedAction, setSelectedAction] = (0, _react.useState)(initialSelectedAction);
  const [lifecycle, setLifecycle] = (0, _react.useState)((0, _streamsSchema.effectiveToIngestLifecycle)(definition.effective_lifecycle));
  const [isSaveButtonDisabled, setIsSaveButtonDisabled] = (0, _react.useState)(selectedAction === 'ilm');
  const isWired = _streamsSchema.Streams.WiredStream.GetResponse.is(definition);
  const toggleButtonsCompressed = (0, _react.useMemo)(() => {
    const buttons = [{
      id: 'indefinite',
      label: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.indefinite', {
        defaultMessage: 'Indefinite'
      })
    }, {
      id: 'custom',
      label: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.customPeriod', {
        defaultMessage: 'Custom period'
      })
    }];
    if (!isServerless) {
      buttons.push({
        id: 'ilm',
        label: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.ilmPolicy', {
          defaultMessage: 'ILM policy'
        })
      });
    }
    return buttons;
  }, [isServerless]);
  const initialCustomPeriodValue = (_dsl$data_retention = (_dsl = definition.effective_lifecycle.dsl) === null || _dsl === void 0 ? void 0 : _dsl.data_retention) !== null && _dsl$data_retention !== void 0 ? _dsl$data_retention : `${_dsl2.DEFAULT_RETENTION_VALUE}${_dsl2.DEFAULT_RETENTION_UNIT.value}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal,
    "aria-labelledby": modalTitleId,
    css: {
      width: '600px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.editRetention', {
    defaultMessage: 'Edit data retention'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, (!isWired || !(0, _streamsSchema.isRoot)(definition.stream.name)) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 17
    }
  }, isWired ? _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.wiredInheritSwitchLabel', {
    defaultMessage: 'Inherit retention'
  }) : _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.classicInheritSwitchLabel', {
    defaultMessage: 'Inherit from index template'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: isWired ? _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.inheritSwitchDescription', {
      defaultMessage: 'Use the parent stream’s retention configuration'
    }) : _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.inheritSwitchDescription', {
      defaultMessage: 'Use the stream’s index template retention configuration'
    }),
    checked: isInheritToggleOn,
    onChange: event => {
      if (event.target.checked) {
        if (isCurrentLifecycleInherit) {
          setLifecycle((0, _streamsSchema.effectiveToIngestLifecycle)(definition.effective_lifecycle));
          setSelectedAction(initialSelectedAction);
        }
        setIsInheritToggleOn(true);
        setIsSaveButtonDisabled(false);
      } else {
        setIsInheritToggleOn(false);
        setIsSaveButtonDisabled(selectedAction === 'ilm');
      }
    },
    "data-test-subj": "inheritDataRetentionSwitch",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.dataRetention', {
    defaultMessage: 'Custom retention'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.dataRetentionOptions', {
      defaultMessage: 'Data retention'
    }),
    onChange: value => {
      if (value === 'indefinite') {
        setLifecycle({
          dsl: {}
        });
        setIsSaveButtonDisabled(false);
      }
      if (value === 'custom') {
        setLifecycle({
          dsl: {
            data_retention: initialCustomPeriodValue
          }
        });
        setIsSaveButtonDisabled(false);
      }
      if (value === 'ilm') {
        setIsSaveButtonDisabled(true);
      }
      setSelectedAction(value);
    },
    options: toggleButtonsCompressed,
    idSelected: selectedAction,
    buttonSize: "m",
    isDisabled: isInheritToggleOn,
    isFullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 13
    }
  }), selectedAction === 'ilm' && (!isInheritToggleOn || isCurrentLifecycleInherit) && /*#__PURE__*/_react.default.createElement(_ilm.IlmField, {
    getIlmPolicies: getIlmPolicies,
    initialValue: lifecycle,
    setLifecycle: setLifecycle,
    setSaveButtonDisabled: setIsSaveButtonDisabled,
    readOnly: isInheritToggleOn,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 15
    }
  }), selectedAction === 'custom' && (!isInheritToggleOn || isCurrentLifecycleInherit) && /*#__PURE__*/_react.default.createElement(_dsl2.DslField, {
    initialValue: lifecycle,
    isDisabled: isInheritToggleOn,
    setLifecycle: setLifecycle,
    setSaveButtonDisabled: setIsSaveButtonDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 15
    }
  }), !isServerless && selectedAction === 'custom' && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.description', {
    defaultMessage: 'This retention period stores data in the hot tier for best indexing and search performance. To use alternative storage tiers, consider an ILM policy.'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "streamsAppModalFooterCancelButton",
    disabled: updateInProgress,
    color: "primary",
    onClick: () => closeModal(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.cancelLifecycleUpdate', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "streamsAppModalFooterButton",
    fill: true,
    disabled: isSaveButtonDisabled,
    isLoading: updateInProgress,
    onClick: () => {
      if (isInheritToggleOn) {
        updateLifecycle({
          inherit: {}
        });
        return;
      }
      if ((0, _streamsSchema.isDisabledLifecycle)(lifecycle) || (0, _streamsSchema.isErrorLifecycle)(lifecycle)) {
        return;
      }
      updateLifecycle(lifecycle);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailLifecycle.saveButton', {
    defaultMessage: 'Save'
  }))))));
}