"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailFailureStore = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _no_failure_store_panel = require("./no_failure_store_panel");
var _failure_store_info = require("./failure_store_info");
var _use_update_failure_store = require("../../../../hooks/use_update_failure_store");
var _use_kibana = require("../../../../hooks/use_kibana");
var _no_permission_banner = require("./no_permission_banner");
var _use_timefilter = require("../../../../hooks/use_timefilter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_lifecycle/failure_store/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Lazy load the FailureStoreModal to reduce bundle size
const LazyFailureStoreModal = /*#__PURE__*/_react.default.lazy(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/failure-store-modal')))).FailureStoreModal
}));
const FailureStoreModal = (0, _sharedUxUtility.withSuspense)(LazyFailureStoreModal);
const StreamDetailFailureStore = ({
  definition,
  data
}) => {
  var _data$stats, _data$stats2, _data$stats3, _data$stats4, _data$stats5, _data$stats6, _data$stats7, _data$stats8;
  const [isFailureStoreModalOpen, setIsFailureStoreModalOpen] = (0, _react.useState)(false);
  const {
    updateFailureStore
  } = (0, _use_update_failure_store.useUpdateFailureStore)();
  const {
    core: {
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  const {
    timeState
  } = (0, _use_timefilter.useTimefilter)();
  const {
    privileges: {
      read_failure_store: readFailureStorePrivilege,
      manage_failure_store: manageFailureStorePrivilege
    }
  } = definition;
  const closeModal = () => {
    setIsFailureStoreModalOpen(false);
  };
  const handleSaveModal = async update => {
    try {
      await updateFailureStore(definition.stream.name, {
        failureStoreEnabled: update.failureStoreEnabled,
        customRetentionPeriod: update.customRetentionPeriod
      });
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.streams.streamDetailFailureStore.updateFailureStoreSuccess', {
          defaultMessage: 'Failure store settings saved'
        })
      });
    } catch (error) {
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.streams.streamDetailFailureStore.updateFailureStoreFailed', {
          defaultMessage: "We couldn't update the failure store settings."
        }),
        text: error.message
      });
    }
    closeModal();
    data.refresh();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, readFailureStorePrivilege ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isFailureStoreModalOpen && manageFailureStorePrivilege && (data === null || data === void 0 ? void 0 : (_data$stats = data.stats) === null || _data$stats === void 0 ? void 0 : _data$stats.fs.config) && /*#__PURE__*/_react.default.createElement(FailureStoreModal, {
    onCloseModal: closeModal,
    onSaveModal: handleSaveModal,
    failureStoreProps: {
      failureStoreEnabled: data === null || data === void 0 ? void 0 : (_data$stats2 = data.stats) === null || _data$stats2 === void 0 ? void 0 : _data$stats2.fs.config.enabled,
      defaultRetentionPeriod: data === null || data === void 0 ? void 0 : (_data$stats3 = data.stats) === null || _data$stats3 === void 0 ? void 0 : _data$stats3.fs.config.retentionPeriod.default,
      customRetentionPeriod: data === null || data === void 0 ? void 0 : (_data$stats4 = data.stats) === null || _data$stats4 === void 0 ? void 0 : _data$stats4.fs.config.retentionPeriod.custom
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 15
    }
  }), data.isLoading || data !== null && data !== void 0 && (_data$stats5 = data.stats) !== null && _data$stats5 !== void 0 && _data$stats5.fs.config.enabled ? /*#__PURE__*/_react.default.createElement(_failure_store_info.FailureStoreInfo, {
    openModal: setIsFailureStoreModalOpen,
    definition: definition,
    statsError: data.error,
    isLoadingStats: data.isLoading,
    stats: (_data$stats6 = data.stats) === null || _data$stats6 === void 0 ? void 0 : _data$stats6.fs.stats,
    config: data === null || data === void 0 ? void 0 : (_data$stats7 = data.stats) === null || _data$stats7 === void 0 ? void 0 : _data$stats7.fs.config,
    timeState: timeState,
    aggregations: data === null || data === void 0 ? void 0 : (_data$stats8 = data.stats) === null || _data$stats8 === void 0 ? void 0 : _data$stats8.fs.aggregations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_no_failure_store_panel.NoFailureStorePanel, {
    openModal: setIsFailureStoreModalOpen,
    definition: definition,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement(_no_permission_banner.NoPermissionBanner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  })));
};
exports.StreamDetailFailureStore = StreamDetailFailureStore;