"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFieldSuggestions = createFieldSuggestions;
var _simulation_state_machine = require("../../../../state_management/simulation_state_machine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Create field suggestions from simulation records and detected fields
 * Uses the centralized field ordering logic from simulation state machine
 */
function createFieldSuggestions(previewRecords, detectedFields) {
  const orderedFields = (0, _simulation_state_machine.getAllFieldsInOrder)(previewRecords, detectedFields);
  return orderedFields.map(fieldName => ({
    name: fieldName
  }));
}