"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EcsRecommendation = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/schema_editor/flyout/ecs_recommendation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EcsRecommendationText = _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditor.ecsRecommendationText', {
  defaultMessage: 'Recommended type'
});
const UknownEcsFieldText = _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditor.uknownEcsFieldText', {
  defaultMessage: 'No recommendation available'
});
const LoadingText = _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditor.ecsRecommendationLoadingText', {
  defaultMessage: 'Loading...'
});
const EcsRecommendation = ({
  recommendation,
  isLoading
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, `${EcsRecommendationText}: `, isLoading ? LoadingText : recommendation !== undefined ? recommendation : UknownEcsFieldText);
};
exports.EcsRecommendation = EcsRecommendation;