"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shorthandUnaryFilterConditionSchema = exports.shorthandBinaryFilterConditionSchema = exports.rangeConditionSchema = exports.orConditionSchema = exports.operatorToHumanReadableNameMap = exports.notConditionSchema = exports.neverConditionSchema = exports.isUnaryFilterCondition = exports.isOrCondition = exports.isNotCondition = exports.isNeverCondition = exports.isFilterCondition = exports.isCondition = exports.isBinaryFilterCondition = exports.isAndCondition = exports.isAlwaysCondition = exports.filterConditionSchema = exports.conditionSchema = exports.andConditionSchema = exports.alwaysConditionSchema = exports.UNARY_OPERATORS = exports.NEVER_CONDITION = exports.BINARY_OPERATORS = exports.ALWAYS_CONDITION = void 0;
var _i18n = require("@kbn/i18n");
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stringOrNumberOrBoolean = _zod.z.union([_zod.z.string(), _zod.z.number(), _zod.z.boolean()]);
const BINARY_OPERATORS = exports.BINARY_OPERATORS = ['eq', 'neq', 'lt', 'lte', 'gt', 'gte', 'contains', 'startsWith', 'endsWith', 'range'];
const UNARY_OPERATORS = exports.UNARY_OPERATORS = ['exists'];
const operatorToHumanReadableNameMap = exports.operatorToHumanReadableNameMap = {
  eq: _i18n.i18n.translate('xpack.streams.filter.equals', {
    defaultMessage: 'equals'
  }),
  neq: _i18n.i18n.translate('xpack.streams.filter.notEquals', {
    defaultMessage: 'not equals'
  }),
  lt: _i18n.i18n.translate('xpack.streams.filter.lessThan', {
    defaultMessage: 'less than'
  }),
  lte: _i18n.i18n.translate('xpack.streams.filter.lessThanOrEquals', {
    defaultMessage: 'less than or equals'
  }),
  gt: _i18n.i18n.translate('xpack.streams.filter.greaterThan', {
    defaultMessage: 'greater than'
  }),
  gte: _i18n.i18n.translate('xpack.streams.filter.greaterThanOrEquals', {
    defaultMessage: 'greater than or equals'
  }),
  contains: _i18n.i18n.translate('xpack.streams.filter.contains', {
    defaultMessage: 'contains'
  }),
  startsWith: _i18n.i18n.translate('xpack.streams.filter.startsWith', {
    defaultMessage: 'starts with'
  }),
  endsWith: _i18n.i18n.translate('xpack.streams.filter.endsWith', {
    defaultMessage: 'ends with'
  }),
  exists: _i18n.i18n.translate('xpack.streams.filter.exists', {
    defaultMessage: 'exists'
  })
};
const rangeConditionSchema = exports.rangeConditionSchema = _zod.z.object({
  gt: stringOrNumberOrBoolean.optional(),
  gte: stringOrNumberOrBoolean.optional(),
  lt: stringOrNumberOrBoolean.optional(),
  lte: stringOrNumberOrBoolean.optional()
});
// Shorthand binary: field + one of the operator keys
const shorthandBinaryFilterConditionSchema = exports.shorthandBinaryFilterConditionSchema = _zod.z.object({
  field: _zodHelpers.NonEmptyString,
  eq: stringOrNumberOrBoolean.optional(),
  neq: stringOrNumberOrBoolean.optional(),
  lt: stringOrNumberOrBoolean.optional(),
  lte: stringOrNumberOrBoolean.optional(),
  gt: stringOrNumberOrBoolean.optional(),
  gte: stringOrNumberOrBoolean.optional(),
  contains: stringOrNumberOrBoolean.optional(),
  startsWith: stringOrNumberOrBoolean.optional(),
  endsWith: stringOrNumberOrBoolean.optional(),
  range: rangeConditionSchema.optional()
}).refine(obj =>
// At least one operator must be present
Object.keys(obj).some(key => BINARY_OPERATORS.includes(key)), {
  message: 'At least one operator must be specified'
});
// Shorthand unary
const shorthandUnaryFilterConditionSchema = exports.shorthandUnaryFilterConditionSchema = _zod.z.object({
  field: _zodHelpers.NonEmptyString,
  exists: _zod.z.boolean().optional()
});
const filterConditionSchema = exports.filterConditionSchema = _zod.z.union([shorthandBinaryFilterConditionSchema, shorthandUnaryFilterConditionSchema]);
const conditionSchema = exports.conditionSchema = _zod.z.lazy(() => _zod.z.union([filterConditionSchema, andConditionSchema, orConditionSchema, notConditionSchema, neverConditionSchema, alwaysConditionSchema]));
const andConditionSchema = exports.andConditionSchema = _zod.z.object({
  and: _zod.z.array(conditionSchema)
});
const orConditionSchema = exports.orConditionSchema = _zod.z.object({
  or: _zod.z.array(conditionSchema)
});
const neverConditionSchema = exports.neverConditionSchema = _zod.z.object({
  never: _zod.z.strictObject({})
});
const alwaysConditionSchema = exports.alwaysConditionSchema = _zod.z.object({
  always: _zod.z.strictObject({})
});
const notConditionSchema = exports.notConditionSchema = _zod.z.object({
  not: _zod.z.lazy(() => conditionSchema)
});
const isBinaryFilterCondition = exports.isBinaryFilterCondition = (0, _zodHelpers.createIsNarrowSchema)(conditionSchema, shorthandBinaryFilterConditionSchema);
const isUnaryFilterCondition = exports.isUnaryFilterCondition = (0, _zodHelpers.createIsNarrowSchema)(conditionSchema, shorthandUnaryFilterConditionSchema);
const isFilterCondition = exports.isFilterCondition = (0, _zodHelpers.createIsNarrowSchema)(conditionSchema, filterConditionSchema);
const isAndCondition = exports.isAndCondition = (0, _zodHelpers.createIsNarrowSchema)(conditionSchema, andConditionSchema);
const isOrCondition = exports.isOrCondition = (0, _zodHelpers.createIsNarrowSchema)(conditionSchema, orConditionSchema);
const isNeverCondition = exports.isNeverCondition = (0, _zodHelpers.createIsNarrowSchema)(conditionSchema, neverConditionSchema);
const isAlwaysCondition = exports.isAlwaysCondition = (0, _zodHelpers.createIsNarrowSchema)(conditionSchema, alwaysConditionSchema);
const isNotCondition = exports.isNotCondition = (0, _zodHelpers.createIsNarrowSchema)(conditionSchema, notConditionSchema);
const isCondition = exports.isCondition = (0, _zodHelpers.createIsNarrowSchema)(_zod.z.unknown(), conditionSchema);
const ALWAYS_CONDITION = exports.ALWAYS_CONDITION = Object.freeze({
  always: {}
});
const NEVER_CONDITION = exports.NEVER_CONDITION = Object.freeze({
  never: {}
});