"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAzureApiVersionParameter = exports.getAxiosOptions = void 0;
exports.getRequestWithStreamOption = getRequestWithStreamOption;
exports.sanitizeRequest = exports.pipeStreamingResponse = void 0;
var _constants = require("../../../../common/openai/constants");
var _openai_utils = require("./openai_utils");
var _azure_openai_utils = require("./azure_openai_utils");
var _other_openai_utils = require("./other_openai_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sanitizeRequest = (provider, url, body, defaultModel) => {
  switch (provider) {
    case _constants.OpenAiProviderType.OpenAi:
      return (0, _openai_utils.sanitizeRequest)(url, body, defaultModel);
    case _constants.OpenAiProviderType.AzureAi:
      return (0, _azure_openai_utils.sanitizeRequest)(url, body);
    case _constants.OpenAiProviderType.Other:
      return (0, _other_openai_utils.sanitizeRequest)(body);
    default:
      return body;
  }
};
exports.sanitizeRequest = sanitizeRequest;
function getRequestWithStreamOption(provider, url, body, stream, defaultModel) {
  switch (provider) {
    case _constants.OpenAiProviderType.OpenAi:
      return (0, _openai_utils.getRequestWithStreamOption)(url, body, stream, defaultModel);
    case _constants.OpenAiProviderType.AzureAi:
      return (0, _azure_openai_utils.getRequestWithStreamOption)(url, body, stream);
    case _constants.OpenAiProviderType.Other:
      return (0, _other_openai_utils.getRequestWithStreamOption)(body, stream, defaultModel);
    default:
      return body;
  }
}
const getAxiosOptions = (provider, apiKey, stream) => {
  const responseType = stream ? {
    responseType: 'stream'
  } : {};
  switch (provider) {
    case _constants.OpenAiProviderType.OpenAi:
    case _constants.OpenAiProviderType.Other:
      return {
        headers: {
          Authorization: `Bearer ${apiKey}`,
          ['content-type']: 'application/json'
        },
        ...responseType
      };
    case _constants.OpenAiProviderType.AzureAi:
      return {
        headers: {
          ['api-key']: apiKey,
          ['content-type']: 'application/json'
        },
        ...responseType
      };
    default:
      return {
        headers: {}
      };
  }
};
exports.getAxiosOptions = getAxiosOptions;
const pipeStreamingResponse = response => {
  // Streaming responses are compressed by the Hapi router by default
  // Set content-type to something that's not recognized by Hapi in order to circumvent this
  response.data.headers = {
    ['Content-Type']: 'dont-compress-this'
  };
  return response.data;
};
exports.pipeStreamingResponse = pipeStreamingResponse;
const getAzureApiVersionParameter = url => {
  var _urlSearchParams$get;
  const urlSearchParams = new URLSearchParams(new URL(url).search);
  return (_urlSearchParams$get = urlSearchParams.get('api-version')) !== null && _urlSearchParams$get !== void 0 ? _urlSearchParams$get : undefined;
};
exports.getAzureApiVersionParameter = getAzureApiVersionParameter;