"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecretsSchema = exports.Response = exports.FailureResponse = exports.CreateAlertParamsSchema = exports.ConfigSchema = exports.CloseAlertParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _lodash = require("lodash");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigSchema = exports.ConfigSchema = _configSchema.schema.object({
  apiUrl: _configSchema.schema.string()
});
const SecretsSchema = exports.SecretsSchema = _configSchema.schema.object({
  apiKey: _configSchema.schema.string()
});
const SuccessfulResponse = _configSchema.schema.object({
  took: _configSchema.schema.number(),
  requestId: _configSchema.schema.string(),
  result: _configSchema.schema.string()
}, {
  unknowns: 'allow'
});
const FailureResponse = exports.FailureResponse = _configSchema.schema.object({
  code: _configSchema.schema.maybe(_configSchema.schema.number()),
  message: _configSchema.schema.maybe(_configSchema.schema.string()),
  result: _configSchema.schema.maybe(_configSchema.schema.string()),
  errors: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    title: _configSchema.schema.string(),
    code: _configSchema.schema.string()
  }))),
  took: _configSchema.schema.maybe(_configSchema.schema.number()),
  requestId: _configSchema.schema.maybe(_configSchema.schema.string())
}, {
  unknowns: 'allow'
});
const Response = exports.Response = _configSchema.schema.oneOf([SuccessfulResponse, FailureResponse]);
const responderTypes = _configSchema.schema.oneOf([_configSchema.schema.literal('team'), _configSchema.schema.literal('user'), _configSchema.schema.literal('escalation'), _configSchema.schema.literal('schedule')]);

/**
 * For more information on the JiraServiceManagement create alert schema see: https://developer.atlassian.com/cloud/jira/service-desk-ops/rest/v1/api-group-integration-events/#api-jsm-ops-integration-v2-alerts-post
 */
const CreateAlertParamsSchema = exports.CreateAlertParamsSchema = _configSchema.schema.object({
  message: _configSchema.schema.string({
    maxLength: 130,
    minLength: 1,
    validate: message => (0, _lodash.isEmpty)(message.trim()) ? i18n.MESSAGE_NON_EMPTY : undefined
  }),
  /**
   * The max length here should be 512 according to JiraServiceManagement's docs but we will sha256 hash the alias if it is longer than 512
   * so we'll not impose a limit on the schema otherwise it'll get rejected prematurely.
   */
  alias: _configSchema.schema.maybe(_configSchema.schema.string()),
  description: _configSchema.schema.maybe(_configSchema.schema.string({
    maxLength: 15000
  })),
  responders: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string(),
    type: responderTypes
  }), {
    maxSize: 50
  })),
  visibleTo: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.object({
    id: _configSchema.schema.string(),
    type: _configSchema.schema.literal('team')
  }), _configSchema.schema.object({
    id: _configSchema.schema.string(),
    type: _configSchema.schema.literal('user')
  })]), {
    maxSize: 50
  })),
  actions: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string({
    maxLength: 50
  }), {
    maxSize: 10
  })),
  tags: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string({
    maxLength: 50
  }), {
    maxSize: 20
  })),
  /**
   * The validation requirement here is that the total characters between the key and value do not exceed 8000. JiraServiceManagement
   * will truncate the value if it would exceed the 8000 but it doesn't throw an error. Because of this I'm intentionally
   * not validating the length of the keys and values here.
   */
  details: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.string())),
  entity: _configSchema.schema.maybe(_configSchema.schema.string({
    maxLength: 512
  })),
  source: _configSchema.schema.maybe(_configSchema.schema.string({
    maxLength: 100
  })),
  priority: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('P1'), _configSchema.schema.literal('P2'), _configSchema.schema.literal('P3'), _configSchema.schema.literal('P4'), _configSchema.schema.literal('P5')])),
  note: _configSchema.schema.maybe(_configSchema.schema.string({
    maxLength: 25000
  })),
  user: _configSchema.schema.maybe(_configSchema.schema.string({
    maxLength: 100
  }))
});
const CloseAlertParamsSchema = exports.CloseAlertParamsSchema = _configSchema.schema.object({
  alias: _configSchema.schema.string(),
  user: _configSchema.schema.maybe(_configSchema.schema.string({
    maxLength: 100
  })),
  source: _configSchema.schema.maybe(_configSchema.schema.string({
    maxLength: 100
  })),
  note: _configSchema.schema.maybe(_configSchema.schema.string({
    maxLength: 25000
  }))
});