"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TheHiveParamsAlertFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var _constants = require("./constants");
var translations = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/thehive/params_alert.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TheHiveParamsAlertFields = ({
  actionParams,
  editAction,
  index,
  errors,
  messageVariables,
  executionMode
}) => {
  var _alert$severity, _alert$tlp, _alert$tags$map, _alert$tags, _alert$title, _alert$description, _alert$type, _alert$source, _alert$sourceRef;
  const alert = (0, _react.useMemo)(() => {
    var _ref;
    return (_ref = actionParams.subActionParams) !== null && _ref !== void 0 ? _ref : {
      tlp: 2,
      severity: 2,
      tags: []
    };
  }, [actionParams.subActionParams]);
  const isTest = executionMode === _public.ActionConnectorMode.Test;
  const [severity, setSeverity] = (0, _react.useState)((_alert$severity = alert.severity) !== null && _alert$severity !== void 0 ? _alert$severity : _constants.severityOptions[1].value);
  const [tlp, setTlp] = (0, _react.useState)((_alert$tlp = alert.tlp) !== null && _alert$tlp !== void 0 ? _alert$tlp : _constants.tlpOptions[2].value);
  const [selectedOptions, setSelected] = (0, _react.useState)((_alert$tags$map = (_alert$tags = alert.tags) === null || _alert$tags === void 0 ? void 0 : _alert$tags.map(tag => ({
    label: tag
  }))) !== null && _alert$tags$map !== void 0 ? _alert$tags$map : []);
  const [isRuleSeverity, setIsRuleSeverity] = (0, _react.useState)(Boolean(alert.isRuleSeverity));
  const onCreateOption = searchValue => {
    var _alert$tags2;
    setSelected([...selectedOptions, {
      label: searchValue
    }]);
    editAction('subActionParams', {
      ...alert,
      tags: [...((_alert$tags2 = alert.tags) !== null && _alert$tags2 !== void 0 ? _alert$tags2 : []), searchValue]
    }, index);
  };
  const onChange = selectedOptionList => {
    setSelected(selectedOptionList);
    editAction('subActionParams', {
      ...alert,
      tags: selectedOptionList.map(option => option.label)
    }, index);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: (key, value) => {
      editAction('subActionParams', {
        ...alert,
        [key]: value
      }, index);
    },
    messageVariables: messageVariables,
    paramsProperty: 'title',
    inputTargetValue: (_alert$title = alert.title) !== null && _alert$title !== void 0 ? _alert$title : undefined,
    wrapField: true,
    formRowProps: {
      label: translations.TITLE_LABEL,
      fullWidth: true,
      helpText: '',
      isInvalid: errors['createAlertParam.title'] !== undefined && Number(errors['createAlertParam.title'].length) > 0 && alert.title !== undefined,
      error: errors['createAlertParam.title']
    },
    errors: errors['createAlertParam.title'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.TextAreaWithMessageVariables, {
    index: index,
    label: translations.DESCRIPTION_LABEL,
    editAction: (key, value) => {
      editAction('subActionParams', {
        ...alert,
        [key]: value
      }, index);
    },
    messageVariables: messageVariables,
    paramsProperty: 'description',
    inputTargetValue: (_alert$description = alert.description) !== null && _alert$description !== void 0 ? _alert$description : undefined,
    errors: errors['createAlertParam.description'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: (key, value) => {
      editAction('subActionParams', {
        ...alert,
        [key]: value
      }, index);
    },
    paramsProperty: 'type',
    inputTargetValue: (_alert$type = alert.type) !== null && _alert$type !== void 0 ? _alert$type : undefined,
    wrapField: true,
    formRowProps: {
      label: translations.TYPE_LABEL,
      fullWidth: true,
      helpText: '',
      isInvalid: errors['createAlertParam.type'] !== undefined && Number(errors['createAlertParam.type'].length) > 0 && alert.type !== undefined,
      error: errors['createAlertParam.type']
    },
    errors: errors['createAlertParam.type'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: (key, value) => {
      editAction('subActionParams', {
        ...alert,
        [key]: value
      }, index);
    },
    paramsProperty: 'source',
    inputTargetValue: (_alert$source = alert.source) !== null && _alert$source !== void 0 ? _alert$source : undefined,
    wrapField: true,
    formRowProps: {
      label: translations.SOURCE_LABEL,
      fullWidth: true,
      helpText: '',
      isInvalid: errors['createAlertParam.source'] !== undefined && Number(errors['createAlertParam.source'].length) > 0 && alert.source !== undefined,
      error: errors['createAlertParam.source']
    },
    errors: errors['createAlertParam.source'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: (key, value) => {
      editAction('subActionParams', {
        ...alert,
        [key]: value
      }, index);
    },
    messageVariables: messageVariables,
    paramsProperty: 'sourceRef',
    inputTargetValue: (_alert$sourceRef = alert.sourceRef) !== null && _alert$sourceRef !== void 0 ? _alert$sourceRef : undefined,
    wrapField: true,
    formRowProps: {
      label: translations.SOURCE_REF_LABEL,
      fullWidth: true,
      helpText: '',
      isInvalid: errors['createAlertParam.sourceRef'] !== undefined && Number(errors['createAlertParam.sourceRef'].length) > 0 && alert.sourceRef !== undefined,
      error: errors['createAlertParam.sourceRef']
    },
    errors: errors['createAlertParam.sourceRef'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }), !isTest && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: translations.IS_RULE_SEVERITY_LABEL,
    checked: Boolean(isRuleSeverity),
    compressed: true,
    "data-test-subj": "rule-severity-toggle",
    onChange: e => {
      setIsRuleSeverity(e.target.checked);
      editAction('subActionParams', {
        ...alert,
        isRuleSeverity: e.target.checked
      }, index);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 11
    }
  })), !Boolean(isRuleSeverity) && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: translations.SEVERITY_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "severitySelectInput",
    disabled: isRuleSeverity,
    value: severity,
    options: _constants.severityOptions,
    onChange: e => {
      editAction('subActionParams', {
        ...alert,
        severity: parseInt(e.target.value, 10)
      }, index);
      setSeverity(parseInt(e.target.value, 10));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: translations.TLP_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "tlpSelectInput",
    value: tlp,
    options: _constants.tlpOptions,
    onChange: e => {
      editAction('subActionParams', {
        ...alert,
        tlp: parseInt(e.target.value, 10)
      }, index);
      setTlp(parseInt(e.target.value, 10));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: translations.TAGS_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "tagsInput",
    fullWidth: true,
    selectedOptions: selectedOptions,
    onCreateOption: onCreateOption,
    onChange: onChange,
    noSuggestions: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_public.JsonEditorWithMessageVariables, {
    messageVariables: messageVariables,
    paramsProperty: 'body',
    inputTargetValue: alert.body,
    label: translations.BODY_LABEL,
    ariaLabel: translations.BODY_DESCRIPTION,
    errors: errors.body,
    onDocumentsChange: json => editAction('subActionParams', {
      ...alert,
      body: json
    }, index),
    dataTestSubj: "thehive-body",
    onBlur: () => {
      if (!alert.body) {
        editAction('subActionParams', {
          ...alert,
          body: null
        }, index);
      }
    },
    isOptionalField: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 7
    }
  }));
};
exports.TheHiveParamsAlertFields = TheHiveParamsAlertFields;