"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var _constants = require("../../../common/d3security/constants");
var _optional_field_label = require("../../common/optional_field_label");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/d3security/params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const D3ParamsFields = ({
  actionParams,
  editAction,
  index,
  messageVariables,
  executionMode,
  errors
}) => {
  const {
    subAction,
    subActionParams
  } = actionParams;
  const {
    body,
    severity,
    eventType
  } = subActionParams !== null && subActionParams !== void 0 ? subActionParams : {};
  const isTest = (0, _react.useMemo)(() => executionMode === _public.ActionConnectorMode.Test, [executionMode]);
  (0, _react.useEffect)(() => {
    if (!subAction) {
      editAction('subAction', isTest ? _constants.SUB_ACTION.TEST : _constants.SUB_ACTION.RUN, index);
    }
  }, [editAction, index, isTest, subAction]);
  const editSubActionParams = (0, _react.useCallback)(params => {
    editAction('subActionParams', {
      ...subActionParams,
      ...params
    }, index);
  }, [editAction, index, subActionParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.eventType,
    isInvalid: false,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.d3security.eventTypeFieldLabel', {
      defaultMessage: 'Event Type'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "eventTypeInput",
    name: "eventType",
    value: eventType,
    onChange: e => {
      editSubActionParams({
        eventType: e.target.value
      });
    },
    isInvalid: false,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors.severity,
    isInvalid: false,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.d3security.severityFieldLabel', {
      defaultMessage: 'Severity'
    }),
    labelAppend: _optional_field_label.OptionalFieldLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "severityInput",
    name: "severity",
    value: severity,
    onChange: e => {
      editSubActionParams({
        severity: e.target.value
      });
    },
    isInvalid: false,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_public.JsonEditorWithMessageVariables, {
    messageVariables: messageVariables,
    paramsProperty: 'body',
    inputTargetValue: body,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.d3security.bodyFieldLabel', {
      defaultMessage: 'Body'
    }),
    ariaLabel: _i18n.i18n.translate('xpack.stackConnectors.components.d3security.bodyCodeEditorAriaLabel', {
      defaultMessage: 'Code editor'
    }),
    errors: errors.body,
    onDocumentsChange: json => {
      editSubActionParams({
        body: json
      });
    },
    onBlur: () => {
      if (!body) {
        editSubActionParams({
          body: ''
        });
      }
    },
    dataTestSubj: "actionJsonEditor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = D3ParamsFields;
module.exports = exports.default;