"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.D3SecuritySecretsSchema = exports.D3SecurityRunActionResponseSchema = exports.D3SecurityRunActionParamsSchema = exports.D3SecurityConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Connector schema
const D3SecurityConfigSchema = exports.D3SecurityConfigSchema = _configSchema.schema.object({
  url: _configSchema.schema.string()
});
const D3SecuritySecretsSchema = exports.D3SecuritySecretsSchema = _configSchema.schema.object({
  token: _configSchema.schema.string()
});

// Run action schema
const D3SecurityRunActionParamsSchema = exports.D3SecurityRunActionParamsSchema = _configSchema.schema.object({
  body: _configSchema.schema.maybe(_configSchema.schema.string()),
  severity: _configSchema.schema.maybe(_configSchema.schema.string({
    defaultValue: _constants.D3SecuritySeverity.EMPTY
  })),
  eventType: _configSchema.schema.maybe(_configSchema.schema.string({
    defaultValue: ''
  }))
});
const D3SecurityRunActionResponseSchema = exports.D3SecurityRunActionResponseSchema = _configSchema.schema.object({
  refid: _configSchema.schema.string()
}, {
  unknowns: 'ignore'
});