"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestQueryRowTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("../../../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_alerts/public/rule_types/es_query/test_query_row/test_query_row_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const styles = {
  grid: (0, _react2.css)`
    .euiDataGridHeaderCell {
      background: none;
    }
    .euiDataGridHeader .euiDataGridHeaderCell {
      border-top: none;
    }
  `
};
const TestQueryRowTable = ({
  preview
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    style: {
      overflow: 'hidden'
    },
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, {
    css: styles.grid,
    "aria-label": _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.testQueryTableAriaLabel', {
      defaultMessage: 'Test query grid'
    }),
    "data-test-subj": "test-query-row-datagrid",
    columns: preview.cols,
    columnVisibility: {
      visibleColumns: preview.cols.map(c => c.id),
      setVisibleColumns: () => {}
    },
    rowCount: preview.rows.length,
    gridStyle: {
      border: 'horizontal',
      rowHover: 'none'
    },
    renderCellValue: ({
      rowIndex,
      columnId
    }) => {
      const value = preview.rows[rowIndex][columnId];
      if (columnId === _common.ALERT_ID_COLUMN && value) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          "data-test-subj": "alert-badge",
          color: "primary",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 52,
            columnNumber: 15
          }
        }, value);
      }
      return value !== null && value !== void 0 ? value : '-';
    },
    pagination: {
      pageIndex: 0,
      pageSize: 10,
      onChangeItemsPerPage: () => {},
      onChangePage: () => {}
    },
    toolbarVisibility: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.stackAlerts.esQuery.ui.testQueryTableNote', {
    defaultMessage: 'This table is a preview and shows data from only the top 5 rows returned by the query.'
  }))));
};
exports.TestQueryRowTable = TestQueryRowTable;