"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSpaces = exports.createSpacesReactContext = void 0;
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  useContext,
  createElement,
  createContext
} = _react.default;
const context = createContext({});
const useSpaces = () => useContext(context);
exports.useSpaces = useSpaces;
const createSpacesReactContext = (services, spacesManager, spacesDataPromise) => {
  const value = {
    spacesManager,
    spacesDataPromise,
    services
  };
  const Provider = ({
    children
  }) => createElement(context.Provider, {
    value,
    children
  });
  return {
    value,
    Provider,
    Consumer: context.Consumer
  };
};
exports.createSpacesReactContext = createSpacesReactContext;